/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.connect.event;

import javafx.event.Event;
import javafx.event.EventHandler;

public final class ConnectEventHandler<T extends Event> {
    private EventProcessorRecord<T> firstRecord;
    private EventProcessorRecord<T> lastRecord;
    private EventHandler<? super T> eventHandler;

    public void setEventHandler(EventHandler<? super T> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public EventHandler<? super T> getEventHandler() {
        return this.eventHandler;
    }

    public void dispatchBubblingEvent(Event event) {
        Event specificEvent = event;
        EventProcessorRecord<Event> record = this.firstRecord;
        while (record != null) {
            if (record.isDisconnected()) {
                this.remove(record);
            } else {
                record.handleBubblingEvent(specificEvent);
            }
            record = record.nextRecord;
        }
        if (this.eventHandler != null) {
            this.eventHandler.handle(specificEvent);
        }
    }

    public void dispatchCapturingEvent(Event event) {
        Event specificEvent = event;
        EventProcessorRecord<Event> record = this.firstRecord;
        while (record != null) {
            if (record.isDisconnected()) {
                this.remove(record);
            } else {
                record.handleCapturingEvent(specificEvent);
            }
            record = record.nextRecord;
        }
    }

    private void remove(EventProcessorRecord<T> record) {
        EventProcessorRecord prevRecord = record.prevRecord;
        EventProcessorRecord nextRecord = record.nextRecord;
        if (prevRecord != null) {
            prevRecord.nextRecord = nextRecord;
        } else {
            this.firstRecord = nextRecord;
        }
        if (nextRecord != null) {
            nextRecord.prevRecord = prevRecord;
        } else {
            this.lastRecord = prevRecord;
        }
    }

    private static abstract class EventProcessorRecord<T extends Event> {
        private EventProcessorRecord<T> nextRecord;
        private EventProcessorRecord<T> prevRecord;

        private EventProcessorRecord() {
        }

        public abstract boolean stores(EventHandler<? super T> var1, boolean var2);

        public abstract void handleBubblingEvent(T var1);

        public abstract void handleCapturingEvent(T var1);

        public abstract boolean isDisconnected();
    }
}

