/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq;

import com.gluonhq.ReleaseConfiguration;
import com.gluonhq.attach.AttachArtifactResolver;
import com.gluonhq.substrate.Constants;
import com.gluonhq.substrate.ProjectConfiguration;
import com.gluonhq.substrate.SubstrateDispatcher;
import com.gluonhq.substrate.model.Triplet;
import com.gluonhq.utils.MavenArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public abstract class NativeBaseMojo
extends AbstractMojo {
    private static final List<String> ALLOWED_DEPENDENCY_TYPES = Collections.singletonList("jar");
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Component
    BuildPluginManager pluginManager;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    File basedir;
    @Parameter(property="gluonfx.graalvmHome")
    String graalvmHome;
    @Parameter(property="gluonfx.javaStaticSdkVersion")
    String javaStaticSdkVersion;
    @Parameter(property="gluonfx.javafxStaticSdkVersion")
    String javafxStaticSdkVersion;
    @Parameter(property="gluonfx.target", defaultValue="host")
    String target;
    @Parameter(property="gluonfx.bundlesList")
    List<String> bundlesList;
    @Parameter(property="gluonfx.resourcesList")
    List<String> resourcesList;
    @Parameter(property="gluonfx.reflectionList")
    List<String> reflectionList;
    @Parameter(property="gluonfx.jniList")
    List<String> jniList;
    @Parameter(property="gluonfx.nativeImageArgs")
    List<String> nativeImageArgs;
    @Parameter(property="gluonfx.runtimeArgs")
    List<String> runtimeArgs;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.directory}/gluonfx")
    File outputDir;
    @Parameter(property="gluonfx.mainClass", required=true)
    String mainClass;
    @Parameter(property="gluonfx.executable", defaultValue="java")
    String executable;
    @Parameter(property="gluonfx.verbose", defaultValue="false")
    String verbose;
    @Parameter(property="gluonfx.attachList")
    List<String> attachList;
    @Parameter(property="gluonfx.enableSWRendering", defaultValue="false")
    String enableSWRendering;
    @Parameter(property="gluonfx.remoteHostName")
    String remoteHostName;
    @Parameter(property="gluonfx.remoteDir")
    String remoteDir;
    @Parameter(property="gluonfx.releaseConfiguration")
    ReleaseConfiguration releaseConfiguration;
    private ProcessDestroyer processDestroyer;

    public SubstrateDispatcher createSubstrateDispatcher() throws IOException, MojoExecutionException {
        if (this.getGraalvmHome().isEmpty()) {
            throw new MojoExecutionException("GraalVM installation directory not found. Either set GRAALVM_HOME as an environment variable or set graalvmHome in gluonfx-plugin configuration");
        }
        ProjectConfiguration substrateConfiguration = this.createSubstrateConfiguration();
        return new SubstrateDispatcher(this.outputDir.toPath(), substrateConfiguration);
    }

    private ProjectConfiguration createSubstrateConfiguration() {
        Triplet targetTriplet;
        ProjectConfiguration clientConfig = new ProjectConfiguration(this.mainClass, this.getProjectClasspath());
        clientConfig.setGraalPath(Path.of(this.getGraalvmHome().get(), new String[0]));
        clientConfig.setJavaStaticSdkVersion(this.javaStaticSdkVersion);
        clientConfig.setJavafxStaticSdkVersion(this.javafxStaticSdkVersion);
        switch (this.target) {
            case "host": {
                targetTriplet = Triplet.fromCurrentOS();
                break;
            }
            case "ios": {
                targetTriplet = new Triplet(Constants.Profile.IOS);
                break;
            }
            case "ios-sim": {
                targetTriplet = new Triplet(Constants.Profile.IOS_SIM);
                break;
            }
            case "android": {
                targetTriplet = new Triplet(Constants.Profile.ANDROID);
                break;
            }
            case "linux-aarch64": {
                targetTriplet = new Triplet(Constants.Profile.LINUX_AARCH64);
                break;
            }
            default: {
                throw new RuntimeException("No valid target found for " + this.target);
            }
        }
        if (this.releaseConfiguration != null) {
            clientConfig.setReleaseConfiguration(this.releaseConfiguration.toSubstrate());
        }
        clientConfig.setTarget(targetTriplet);
        clientConfig.setBundlesList(this.bundlesList);
        clientConfig.setResourcesList(this.resourcesList);
        clientConfig.setJniList(this.jniList);
        clientConfig.setCompilerArgs(this.nativeImageArgs);
        clientConfig.setRuntimeArgs(this.runtimeArgs);
        clientConfig.setReflectionList(this.reflectionList);
        clientConfig.setAppId(this.project.getGroupId() + "." + this.project.getArtifactId());
        clientConfig.setAppName(this.project.getName());
        clientConfig.setVerbose("true".equals(this.verbose));
        clientConfig.setUsePrismSW("true".equals(this.enableSWRendering));
        clientConfig.setRemoteHostName(this.remoteHostName);
        clientConfig.setRemoteDir(this.remoteDir);
        return clientConfig;
    }

    ProcessDestroyer getProcessDestroyer() {
        if (this.processDestroyer == null) {
            this.processDestroyer = new ShutdownHookProcessDestroyer();
        }
        return this.processDestroyer;
    }

    private String getProjectClasspath() {
        List<File> classPath = this.getClasspathElements(this.project);
        this.getLog().debug((CharSequence)("classPath = " + classPath));
        return classPath.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    private List<File> getClasspathElements(MavenProject project) {
        MavenArtifactResolver.initRepositories(project.getRepositories());
        List<org.apache.maven.artifact.Artifact> attachDependencies = this.getAttachDependencies();
        List<File> list = Stream.concat(project.getArtifacts().stream(), attachDependencies.stream()).filter(d -> ALLOWED_DEPENDENCY_TYPES.stream().anyMatch(t -> t.equals(d.getType()))).sorted((a1, a2) -> {
            int compare = a1.compareTo(a2);
            if (compare == 0) {
                return a1.hasClassifier() ? 1 : (a2.hasClassifier() ? -1 : 0);
            }
            return compare;
        }).map(org.apache.maven.artifact.Artifact::getFile).collect(Collectors.toList());
        list.add(0, new File(project.getBuild().getOutputDirectory()));
        this.getRuntimeDependencies().stream().filter(d -> !list.contains(d)).forEach(list::add);
        this.getProvidedDependencies().stream().filter(list::contains).forEach(list::remove);
        return list;
    }

    List<org.apache.maven.artifact.Artifact> getAttachDependencies() {
        List dependencies = this.project.getDependencies();
        this.project.getArtifacts().stream().filter(a -> "com.gluonhq.attach".equals(a.getGroupId())).map(a -> {
            Dependency d = new Dependency();
            d.setGroupId(a.getGroupId());
            d.setArtifactId(a.getArtifactId());
            d.setVersion(a.getVersion());
            return d;
        }).forEach(dependencies::add);
        Map<String, org.apache.maven.artifact.Artifact> attachMap = AttachArtifactResolver.findArtifactsForTarget(dependencies, this.target);
        if (this.attachList != null) {
            return Stream.concat(this.attachList.stream(), Stream.of("util")).distinct().map(attachMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<org.apache.maven.artifact.Artifact>();
    }

    private List<File> getRuntimeDependencies() {
        return this.getDependencies("runtime");
    }

    private List<File> getProvidedDependencies() {
        return this.getDependencies("provided");
    }

    private List<File> getDependencies(String scope) {
        if (scope == null || scope.isEmpty()) {
            return new ArrayList<File>();
        }
        return this.project.getDependencies().stream().filter(d -> ALLOWED_DEPENDENCY_TYPES.stream().anyMatch(t -> t.equals(d.getType()))).filter(d -> scope.equals(d.getScope())).map(d -> new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion())).flatMap(a -> {
            Set<org.apache.maven.artifact.Artifact> resolve = MavenArtifactResolver.getInstance().resolve((Artifact)a);
            if (resolve == null) {
                return Stream.empty();
            }
            return resolve.stream();
        }).distinct().map(org.apache.maven.artifact.Artifact::getFile).collect(Collectors.toList());
    }

    Optional<String> getGraalvmHome() {
        return Optional.ofNullable(this.graalvmHome).or(() -> Optional.ofNullable(System.getenv("GRAALVM_HOME")));
    }
}

