/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq;

import com.gluonhq.NativeBaseMojo;
import com.gluonhq.attach.AttachService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class RunMojo
extends NativeBaseMojo {
    private static final String POM_XML = "pom.xml";
    private static final String RUN_POM_XML = "runPom.xml";

    public void execute() throws MojoExecutionException {
        try {
            this.createSubstrateDispatcher();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error creating Substrate Dispatcher", e);
        }
        DefaultInvocationRequest invocationRequest = new DefaultInvocationRequest();
        invocationRequest.setProfiles(this.project.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toList()));
        invocationRequest.setProperties(this.session.getRequest().getUserProperties());
        File pomFile = new File(POM_XML);
        File runPomFile = new File(RUN_POM_XML);
        try (FileInputStream is = new FileInputStream(POM_XML);){
            Model model = new MavenXpp3Reader().read((InputStream)is);
            model.getBuild().getPlugins().stream().filter(p -> p.getGroupId().equalsIgnoreCase("org.openjfx") && p.getArtifactId().equalsIgnoreCase("javafx-maven-plugin")).findFirst().orElseThrow(() -> new MojoExecutionException("No JavaFX plugin found"));
            model.getDependencies().stream().filter(p -> p.getGroupId().equalsIgnoreCase("com.gluonhq.attach")).filter(p -> Arrays.stream(AttachService.values()).filter(AttachService::isDesktopSupported).anyMatch(attach -> attach.getServiceName().equalsIgnoreCase(p.getArtifactId()))).forEach(p -> p.setClassifier("desktop"));
            try (FileOutputStream os = new FileOutputStream(runPomFile);){
                new MavenXpp3Writer().write((OutputStream)os, model);
            }
        }
        catch (Exception e) {
            if (runPomFile.exists()) {
                runPomFile.delete();
            }
            throw new MojoExecutionException("Error reading pom", e);
        }
        if (!this.project.getActiveProfiles().isEmpty()) {
            String activeProfiles = this.project.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.joining(","));
            this.getLog().warn((CharSequence)String.format("Active profile(s) '%s' will be ignored for 'client:run' goal on the host machine", activeProfiles));
        }
        invocationRequest.setPomFile(runPomFile);
        invocationRequest.setGoals(Collections.singletonList("javafx:run"));
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult invocationResult = invoker.execute((InvocationRequest)invocationRequest);
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Error, javafx:run failed", (Exception)invocationResult.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        finally {
            if (runPomFile.exists()) {
                runPomFile.delete();
            }
        }
    }
}

