/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq;

import com.gluonhq.NativeBaseMojo;
import com.gluonhq.attach.AttachService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="runagent", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class NativeRunAgentMojo
extends NativeBaseMojo {
    private static final String AGENTLIB_NATIVE_IMAGE_AGENT_STRING = "-agentlib:native-image-agent=access-filter-file=src/main/resources/META-INF/native-image/filter-file.json,config-merge-dir=src/main/resources/META-INF/native-image";
    private static final List<String> AGENTLIB_EXCLUSION_RULES = Arrays.asList("com.sun.glass.ui.mac.*", "com.sun.prism.es2.MacGLFactory", "com.sun.glass.ui.gtk.*", "com.sun.prism.es2.X11GLFactory", "com.gluonhq.attach.**");
    @Parameter(readonly=true, required=true, defaultValue="${basedir}/pom.xml")
    String pom;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}/src/main/resources/META-INF/native-image")
    String agentDir;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}/src/main/resources/META-INF/native-image/filter-file.json")
    String agentFilter;
    @Parameter(readonly=true, required=true, defaultValue="${project.basedir}/agentPom.xml")
    String agentPom;

    public void execute() throws MojoExecutionException {
        try {
            this.createSubstrateDispatcher();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error creating Substrate Dispatcher", e);
        }
        DefaultInvocationRequest invocationRequest = new DefaultInvocationRequest();
        invocationRequest.setProfiles(this.project.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toList()));
        invocationRequest.setProperties(this.session.getRequest().getUserProperties());
        File agentDirFile = new File(this.agentDir);
        if (!agentDirFile.exists()) {
            agentDirFile.mkdirs();
        }
        try {
            this.createFilterFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating agent filter", (Exception)e);
        }
        File agentPomFile = new File(this.agentPom);
        try (FileInputStream is = new FileInputStream(new File(this.pom));){
            Model model = new MavenXpp3Reader().read((InputStream)is);
            model.getBuild().getPlugins().stream().filter(p -> p.getGroupId().equalsIgnoreCase("org.openjfx") && p.getArtifactId().equalsIgnoreCase("javafx-maven-plugin")).findFirst().ifPresentOrElse(p -> p.setConfiguration(this.modifyConfiguration(p.getConfiguration())), () -> this.getLog().warn((CharSequence)"No JavaFX plugin found", (Throwable)new MojoExecutionException("No JavaFX plugin found")));
            model.getDependencies().stream().filter(p -> p.getGroupId().equalsIgnoreCase("com.gluonhq.attach")).filter(p -> Arrays.stream(AttachService.values()).filter(AttachService::isDesktopSupported).anyMatch(attach -> attach.getServiceName().equalsIgnoreCase(p.getArtifactId()))).forEach(p -> p.setClassifier("desktop"));
            try (FileOutputStream os = new FileOutputStream(agentPomFile);){
                new MavenXpp3Writer().write((OutputStream)os, model);
            }
        }
        catch (Exception e) {
            if (agentPomFile.exists()) {
                agentPomFile.delete();
            }
            throw new MojoExecutionException("Error generating agent pom", e);
        }
        invocationRequest.setPomFile(agentPomFile);
        invocationRequest.setGoals(Collections.singletonList("javafx:run"));
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult invocationResult = invoker.execute((InvocationRequest)invocationRequest);
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException("Error, javafx:run failed", (Exception)invocationResult.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error", (Exception)((Object)e));
        }
        finally {
            if (agentPomFile.exists()) {
                agentPomFile.delete();
            }
        }
    }

    private Object modifyConfiguration(Object config) {
        Xpp3Dom dom = config == null ? new Xpp3Dom("configuration") : (Xpp3Dom)config;
        Xpp3Dom executable = dom.getChild("executable");
        String graalVMJava = Path.of(this.getGraalvmHome().get(), "bin", "java").toString();
        if (executable == null) {
            Xpp3Dom d = new Xpp3Dom("executable");
            d.setValue(graalVMJava);
            dom.addChild(d);
        } else {
            executable.setValue(graalVMJava);
        }
        Xpp3Dom options = dom.getChild("options");
        if (options == null) {
            Xpp3Dom os = new Xpp3Dom("options");
            Xpp3Dom o = new Xpp3Dom("option");
            o.setValue(AGENTLIB_NATIVE_IMAGE_AGENT_STRING);
            os.addChild(o);
            dom.addChild(os);
        } else {
            Stream.of(options.getChildren()).filter(i -> i.getValue() != null && i.getValue().contains("native-image-agent")).findFirst().ifPresentOrElse(i -> i.setValue(AGENTLIB_NATIVE_IMAGE_AGENT_STRING), () -> {
                Xpp3Dom o = new Xpp3Dom("option");
                o.setValue(AGENTLIB_NATIVE_IMAGE_AGENT_STRING);
                options.addChild(o);
            });
        }
        return config;
    }

    private void createFilterFile() throws IOException {
        File agentDirFilter = new File(this.agentFilter);
        if (agentDirFilter.exists()) {
            agentDirFilter.delete();
        }
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(agentDirFilter)));){
            bw.write("{ \"rules\": [\n");
            boolean ruleHasBeenWritten = false;
            for (String rule : AGENTLIB_EXCLUSION_RULES) {
                if (ruleHasBeenWritten) {
                    bw.write(",\n");
                } else {
                    ruleHasBeenWritten = true;
                }
                bw.write("    {\"excludeClasses\" : \"" + rule + "\"}");
            }
            bw.write("\n  ]\n");
            bw.write("}\n");
        }
    }
}

