/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.utils;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Repository;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public class MavenArtifactResolver {
    private static final String DEFAULT_LOCAL_REPO = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
    private final org.eclipse.aether.RepositorySystem repositorySystem = this.createRepositorySystem();
    private final List<RemoteRepository> remoteRepositories;
    private final RepositorySystemSession systemSession = this.createRepositorySystemSession(this.repositorySystem, DEFAULT_LOCAL_REPO);
    private static MavenArtifactResolver instance;

    public static MavenArtifactResolver getInstance() {
        if (instance == null) {
            throw new IllegalStateException("MavenArtifactResolver not initialized");
        }
        return instance;
    }

    private MavenArtifactResolver(List<Repository> repositories) {
        this.remoteRepositories = new LinkedList<RemoteRepository>();
        repositories.forEach(r -> {
            org.apache.maven.model.RepositoryPolicy releases = r.getReleases();
            RepositoryPolicy releasesRepositoryPolicy = null;
            if (releases != null) {
                releasesRepositoryPolicy = new RepositoryPolicy(releases.isEnabled(), releases.getUpdatePolicy() == null ? "never" : releases.getUpdatePolicy(), releases.getChecksumPolicy());
            }
            RepositoryPolicy snapshotsRepositoryPolicy = null;
            org.apache.maven.model.RepositoryPolicy snapshots = r.getSnapshots();
            if (snapshots != null) {
                snapshotsRepositoryPolicy = new RepositoryPolicy(snapshots.isEnabled(), snapshots.getUpdatePolicy() == null ? "never" : snapshots.getUpdatePolicy(), snapshots.getChecksumPolicy());
            }
            if (releasesRepositoryPolicy == null && snapshotsRepositoryPolicy == null) {
                if (r.getUrl().toLowerCase(Locale.ROOT).contains("/release")) {
                    releasesRepositoryPolicy = new RepositoryPolicy(true, "daily", "warn");
                    snapshotsRepositoryPolicy = new RepositoryPolicy(false, "daily", "warn");
                } else if (r.getUrl().toLowerCase(Locale.ROOT).contains("/snapshot")) {
                    releasesRepositoryPolicy = new RepositoryPolicy(false, "daily", "warn");
                    snapshotsRepositoryPolicy = new RepositoryPolicy(true, "daily", "warn");
                }
            }
            RemoteRepository repository = new RemoteRepository.Builder(r.getId(), "default", r.getUrl()).setReleasePolicy(releasesRepositoryPolicy).setSnapshotPolicy(snapshotsRepositoryPolicy).build();
            this.remoteRepositories.add(repository);
        });
    }

    public static void initRepositories(List<Repository> repositories) {
        if (instance != null) {
            return;
        }
        instance = new MavenArtifactResolver(repositories);
    }

    private org.eclipse.aether.RepositorySystem createRepositorySystem() {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, FileTransporterFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        serviceLocator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                throw new RuntimeException(exception);
            }
        });
        return (org.eclipse.aether.RepositorySystem)serviceLocator.getService(org.eclipse.aether.RepositorySystem.class);
    }

    private DefaultRepositorySystemSession createRepositorySystemSession(org.eclipse.aether.RepositorySystem system, String localRepoPath) {
        DefaultRepositorySystemSession systemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepoPath);
        systemSession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)systemSession, localRepo));
        return systemSession;
    }

    public Set<org.apache.maven.artifact.Artifact> resolve(Artifact artifact) {
        return this.resolve(artifact, null);
    }

    public Set<org.apache.maven.artifact.Artifact> resolve(Artifact artifact, DependencyFilter exclusionsFilter) {
        List artifactResults;
        ArtifactResult resolvedArtifact;
        try {
            List<ArtifactRequest> artifactRequests = Arrays.asList(new ArtifactRequest((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier() != null ? artifact.getClassifier() : "", artifact.getExtension(), artifact.getVersion()), this.remoteRepositories, "runtime"));
            List results = this.repositorySystem.resolveArtifacts(this.systemSession, artifactRequests);
            resolvedArtifact = (ArtifactResult)results.get(results.size() - 1);
        }
        catch (ArtifactResolutionException e) {
            Logger.getLogger(MavenArtifactResolver.class.getName()).log(Level.SEVERE, "Error resolving artifact: " + e.getMessage());
            return null;
        }
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(resolvedArtifact.getArtifact(), "compile"));
        collectRequest.setRepositories(this.remoteRepositories);
        DependencyFilter classpathFilter = exclusionsFilter != null ? DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"}), DependencyFilterUtils.notFilter((DependencyFilter)exclusionsFilter)}) : DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"});
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
        try {
            artifactResults = this.repositorySystem.resolveDependencies(this.systemSession, dependencyRequest).getArtifactResults();
        }
        catch (DependencyResolutionException e) {
            e.printStackTrace();
            return null;
        }
        return artifactResults.stream().map(ArtifactResult::getArtifact).map(a -> {
            org.apache.maven.artifact.DefaultArtifact ar = new org.apache.maven.artifact.DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "compile", "jar", a.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
            ar.setFile(a.getFile());
            return ar;
        }).collect(Collectors.toSet());
    }
}

