/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.ignite.spring;

import com.gluonhq.ignite.DIContext;
import com.gluonhq.ignite.spring.FXModule;
import com.gluonhq.ignite.spring.SpringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringContext
implements DIContext {
    private final Object contextRoot;
    private ConfigurableApplicationContext appContext;
    private final Supplier<Collection<String>> scanPackages;

    public SpringContext(Object contextRoot, Supplier<Collection<String>> scanPackages) {
        this.contextRoot = Objects.requireNonNull(contextRoot);
        this.appContext = new AnnotationConfigApplicationContext();
        this.scanPackages = Objects.requireNonNull(scanPackages);
    }

    public SpringContext(Object contextRoot) {
        this(contextRoot, List::of);
    }

    public void injectMembers(Object instance) {
        SpringUtils.injectMembers((ApplicationContext)this.appContext, instance);
    }

    public <T> T getInstance(Class<T> type) {
        return SpringUtils.getInstance((ApplicationContext)this.appContext, type);
    }

    public final void init() {
        String[] uniquePackages = new HashSet<String>(this.scanPackages.get()).toArray(new String[0]);
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.register(new Class[]{FXModule.class});
        context.scan(uniquePackages);
        context.refresh();
        this.appContext = context;
        this.injectMembers(this.contextRoot);
    }

    public final void init(Supplier<ConfigurableApplicationContext> applicationContextBuilder) {
        this.appContext = Objects.requireNonNull(applicationContextBuilder).get();
        this.injectMembers(this.contextRoot);
    }
}

