/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.ignite.spring;

import java.lang.reflect.InvocationTargetException;
import org.springframework.context.ApplicationContext;

class SpringUtils {
    private SpringUtils() {
    }

    public static void injectMembers(ApplicationContext appContext, Object instance) {
        appContext.getAutowireCapableBeanFactory().autowireBean(instance);
    }

    public static <T> T getInstance(ApplicationContext appContext, Class<T> type) {
        T instance = null;
        try {
            instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SpringUtils.injectMembers(appContext, instance);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create instance of specified class:  " + type.getName(), e);
        }
        return instance;
    }
}

