/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndClient;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.binding.AfcClientRef;
import org.robovm.libimobiledevice.binding.AfcClientRefOut;
import org.robovm.libimobiledevice.binding.AfcError;
import org.robovm.libimobiledevice.binding.AfcFileMode;
import org.robovm.libimobiledevice.binding.AfcLinkType;
import org.robovm.libimobiledevice.binding.IntOut;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStruct;
import org.robovm.libimobiledevice.binding.LongOut;
import org.robovm.libimobiledevice.binding.StringArray;
import org.robovm.libimobiledevice.binding.StringArrayOut;

public class AfcClient
implements AutoCloseable {
    public static final String SERVICE_NAME = "com.apple.afc";
    public static final String DEVICE_INFO_KEY_FS_TOTAL_BYTES = "FSTotalBytes";
    public static final String DEVICE_INFO_KEY_FS_FREE_BYTES = "FSFreeBytes";
    public static final String DEVICE_INFO_KEY_FS_BLOCK_SIZE = "FSBlockSize";
    public static final String DEVICE_INFO_KEY_MODEL = "Model";
    public static final String FILE_INFO_KEY_ST_BIRTHTIME = "st_birthtime";
    public static final String FILE_INFO_KEY_ST_MTIME = "st_mtime";
    public static final String FILE_INFO_KEY_ST_BLOCKS = "st_blocks";
    public static final String FILE_INFO_KEY_ST_NLINK = "st_nlink";
    public static final String FILE_INFO_KEY_ST_SIZE = "st_size";
    public static final String FILE_INFO_KEY_ST_IFMT = "st_ifmt";
    public static final String FILE_INFO_KEY_LINK_TARGET = "LinkTarget";
    protected AfcClientRef ref;

    AfcClient(AfcClientRef ref) {
        this.ref = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AfcClient(IDevice device, LockdowndServiceDescriptor service) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        if (service == null) {
            throw new NullPointerException("service");
        }
        AfcClientRefOut refOut = new AfcClientRefOut();
        LockdowndServiceDescriptorStruct serviceStruct = new LockdowndServiceDescriptorStruct();
        serviceStruct.setPort((short)service.getPort());
        serviceStruct.setSslEnabled(service.isSslEnabled());
        try {
            AfcClient.checkResult(LibIMobileDevice.afc_client_new(device.getRef(), serviceStruct, refOut));
            this.ref = refOut.getValue();
        }
        finally {
            serviceStruct.delete();
            refOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readDirectory(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        StringArrayOut listOut = new StringArrayOut();
        try {
            AfcClient.checkResult(LibIMobileDevice.afc_read_directory(this.getRef(), dir, listOut));
            StringArray list = listOut.getValue();
            ArrayList<String> result = new ArrayList<String>();
            if (list != null) {
                String s;
                int i = 0;
                while ((s = list.get(i)) != null) {
                    result.add(s);
                    ++i;
                }
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            LibIMobileDevice.delete_StringArray_values_z(listOut.getValue());
            listOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDeviceInfo() {
        StringArrayOut infosOut = new StringArrayOut();
        try {
            AfcClient.checkResult(LibIMobileDevice.afc_get_device_info(this.getRef(), infosOut));
            StringArray list = infosOut.getValue();
            TreeMap<String, String> result = new TreeMap<String, String>();
            if (list != null) {
                String value;
                String key;
                int i = 0;
                while ((key = list.get(i++)) != null && (value = list.get(i++)) != null) {
                    result.put(key, value);
                }
            }
            TreeMap<String, String> treeMap = result;
            return treeMap;
        }
        finally {
            LibIMobileDevice.delete_StringArray_values_z(infosOut.getValue());
            infosOut.delete();
        }
    }

    public int getBlockSize() {
        return Integer.parseInt(this.getDeviceInfo().get(DEVICE_INFO_KEY_FS_BLOCK_SIZE));
    }

    public long getFreeBytes() {
        return Long.parseLong(this.getDeviceInfo().get(DEVICE_INFO_KEY_FS_FREE_BYTES));
    }

    public long getTotalBytes() {
        return Long.parseLong(this.getDeviceInfo().get(DEVICE_INFO_KEY_FS_TOTAL_BYTES));
    }

    public String getModel() {
        return this.getDeviceInfo().get(DEVICE_INFO_KEY_MODEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFileInfo(String path) {
        StringArrayOut infolistOut = new StringArrayOut();
        try {
            AfcClient.checkResult(LibIMobileDevice.afc_get_file_info(this.getRef(), path, infolistOut));
            StringArray list = infolistOut.getValue();
            TreeMap<String, String> result = new TreeMap<String, String>();
            if (list != null) {
                String value;
                String key;
                int i = 0;
                while ((key = list.get(i++)) != null && (value = list.get(i++)) != null) {
                    result.put(key, value);
                }
            }
            TreeMap<String, String> treeMap = result;
            return treeMap;
        }
        finally {
            LibIMobileDevice.delete_StringArray_values_z(infolistOut.getValue());
            infolistOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fileOpen(String path, AfcFileMode mode) {
        LongOut handleOut = new LongOut();
        try {
            AfcClient.checkResult(LibIMobileDevice.afc_file_open(this.getRef(), path, mode, handleOut));
            long l = handleOut.getValue();
            return l;
        }
        finally {
            handleOut.delete();
        }
    }

    public void fileClose(long handle) {
        AfcClient.checkResult(LibIMobileDevice.afc_file_close(this.getRef(), handle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fileRead(long handle, byte[] buffer, int offset, int count) {
        if ((offset | count) < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
        }
        IntOut bytesReadOut = new IntOut();
        try {
            AfcClient.checkResult(LibIMobileDevice.afc_file_read(this.getRef(), handle, data, count, bytesReadOut));
            int bytesRead = bytesReadOut.getValue();
            if (bytesRead == 0) {
                int n = -1;
                return n;
            }
            if (data != buffer) {
                System.arraycopy(data, 0, buffer, offset, bytesRead);
            }
            int n = bytesRead;
            return n;
        }
        finally {
            bytesReadOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fileWrite(long handle, byte[] buffer, int offset, int count) {
        if ((offset | count) < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
            System.arraycopy(buffer, offset, data, 0, count);
        }
        IntOut bytesWrittenOut = new IntOut();
        try {
            int bytesWritten;
            AfcClient.checkResult(LibIMobileDevice.afc_file_write(this.getRef(), handle, data, count, bytesWrittenOut));
            int n = bytesWritten = bytesWrittenOut.getValue();
            return n;
        }
        finally {
            bytesWrittenOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileCopy(File localFile, String remoteFile) throws IOException {
        long handle = this.fileOpen(remoteFile, AfcFileMode.AFC_FOPEN_WRONLY);
        try (FileInputStream is = new FileInputStream(localFile);){
            int n = 0;
            byte[] buffer = new byte[65536];
            while ((n = ((InputStream)is).read(buffer)) != -1) {
                this.fileWrite(handle, buffer, 0, n);
            }
        }
        finally {
            this.fileClose(handle);
        }
    }

    public void removePath(String path) {
        this.removePath(path, false);
    }

    public void removePath(String path, boolean recurse) {
        if (!recurse) {
            AfcClient.checkResult(LibIMobileDevice.afc_remove_path(this.getRef(), path));
        } else {
            AfcError rc = LibIMobileDevice.afc_remove_path(this.getRef(), path);
            if (rc == AfcError.AFC_E_DIR_NOT_EMPTY) {
                for (String child : this.readDirectory(path)) {
                    if (".".equals(child) || "..".equals(child)) continue;
                    this.removePath(this.stripDirSep(path) + "/" + child, true);
                }
                rc = LibIMobileDevice.afc_remove_path(this.getRef(), path);
            }
            AfcClient.checkResult(rc);
        }
    }

    public void renamePath(String from, String to) {
        AfcClient.checkResult(LibIMobileDevice.afc_rename_path(this.getRef(), from, to));
    }

    public void makeDirectory(String dir) {
        AfcClient.checkResult(LibIMobileDevice.afc_make_directory(this.getRef(), dir));
    }

    public void makeLink(AfcLinkType type, String target, String source) {
        AfcClient.checkResult(LibIMobileDevice.afc_make_link(this.getRef(), type, target, source));
    }

    private String stripDirSep(String s) {
        int end;
        for (end = s.length(); end > 0 && s.charAt(end - 1) == '/'; --end) {
        }
        return s.substring(0, end);
    }

    private String toAbsoluteDevicePath(String root, Path path) {
        String child = this.toRelativeDevicePath(path);
        return this.stripDirSep(root) + (child.length() > 0 ? "/" + this.toRelativeDevicePath(path) : "");
    }

    private String toRelativeDevicePath(Path path) {
        StringBuilder sb = new StringBuilder();
        int count = path.getNameCount();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append(path.getName(i));
        }
        return sb.toString();
    }

    public void upload(File localFile, String targetPath) throws IOException {
        this.upload(localFile, targetPath, null);
    }

    public void upload(File localFile, final String targetPath, final UploadProgressCallback callback) throws IOException {
        this.makeDirectory(targetPath);
        final Path root = localFile.toPath().getParent();
        final byte[] buffer = new byte[65536];
        class FileCounterVisitor
        extends SimpleFileVisitor<Path> {
            int count;

            FileCounterVisitor() {
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ++this.count;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                ++this.count;
                return FileVisitResult.CONTINUE;
            }
        }
        FileCounterVisitor visitor = new FileCounterVisitor();
        if (callback != null) {
            Files.walkFileTree(localFile.toPath(), visitor);
        }
        try {
            final int fileCount = visitor.count;
            Files.walkFileTree(localFile.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                int filesUploaded = 0;

                private void reportProgress(Path path) {
                    if (callback != null) {
                        callback.progress(path.toFile(), 100 * this.filesUploaded / fileCount);
                    }
                    ++this.filesUploaded;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.reportProgress(dir);
                    String deviceDir = AfcClient.this.toAbsoluteDevicePath(targetPath, root.relativize(dir));
                    AfcClient.this.makeDirectory(deviceDir);
                    return FileVisitResult.CONTINUE;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    this.reportProgress(file);
                    String deviceFile = AfcClient.this.toAbsoluteDevicePath(targetPath, root.relativize(file));
                    if (Files.isSymbolicLink(file)) {
                        Path linkTargetPath = Files.readSymbolicLink(file);
                        AfcClient.this.makeLink(AfcLinkType.AFC_SYMLINK, AfcClient.this.toRelativeDevicePath(linkTargetPath), deviceFile);
                    } else if (Files.isRegularFile(file, LinkOption.NOFOLLOW_LINKS)) {
                        long fd = AfcClient.this.fileOpen(deviceFile, AfcFileMode.AFC_FOPEN_WRONLY);
                        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                            int n = 0;
                            while ((n = is.read(buffer)) != -1) {
                                AfcClient.this.fileWrite(fd, buffer, 0, n);
                            }
                        }
                        finally {
                            AfcClient.this.fileClose(fd);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (callback != null) {
                callback.success();
            }
        }
        catch (IOException e) {
            if (callback != null) {
                callback.error(e.getMessage());
            }
            throw e;
        }
        catch (LibIMobileDeviceException e) {
            if (callback != null) {
                callback.error(e.getMessage());
            }
            throw e;
        }
    }

    protected AfcClientRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.afc_client_free(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    private static void checkResult(AfcError result) {
        if (result != AfcError.AFC_E_SUCCESS) {
            throw new LibIMobileDeviceException(result.swigValue(), result.name());
        }
    }

    private void list(String path, boolean recurse) {
        this.list(path, this.stripDirSep(path).replaceAll(".*?([^/]+)$", "$1"), "", recurse, new PrintWriter(System.out));
    }

    private void list(String path, String filename, String indent, boolean recurse, PrintWriter out) {
        Map<String, String> info = this.getFileInfo(path);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        long birthTime = Long.parseLong(info.get(FILE_INFO_KEY_ST_BIRTHTIME)) / 1000L / 1000L;
        long mtime = Long.parseLong(info.get(FILE_INFO_KEY_ST_MTIME)) / 1000L / 1000L;
        long size = Long.parseLong(info.get(FILE_INFO_KEY_ST_SIZE));
        if ("S_IFDIR".equals(info.get(FILE_INFO_KEY_ST_IFMT))) {
            out.format("%s %s %9d (%s)\t%s%s/\n", df.format(new Date(birthTime)), df.format(new Date(mtime)), size, info.get(FILE_INFO_KEY_ST_IFMT), indent, filename);
            out.flush();
            for (String f : this.readDirectory(path)) {
                if (f.equals("..") || f.equals(".") || !recurse) continue;
                String childPath = path + "/" + f;
                this.list(childPath, f, indent + "  ", recurse, out);
            }
        } else if ("S_IFLNK".equals(info.get(FILE_INFO_KEY_ST_IFMT))) {
            out.format("%s %s %9d (%s)\t%s%s -> %s\n", df.format(new Date(birthTime)), df.format(new Date(mtime)), size, info.get(FILE_INFO_KEY_ST_IFMT), indent, filename, info.get(FILE_INFO_KEY_LINK_TARGET));
            out.flush();
        } else {
            out.format("%s %s %9d (%s)\t%s%s\n", df.format(new Date(birthTime)), df.format(new Date(mtime)), size, info.get(FILE_INFO_KEY_ST_IFMT), indent, filename);
            out.flush();
        }
    }

    private static void printUsageAndExit() {
        System.err.println(AfcClient.class.getName() + " [deviceid] <action> ...");
        System.err.println("  Actions:");
        System.err.println("    deviceinfo       Prints device file system information.");
        System.err.println("    rm [-f] <path>   Deletes <path> from the device. Deletes non-empty dirs if -f is specified.");
        System.err.println("    ls [-r] <path>   Lists the contents of the specified dir.");
        System.err.println("    mkdir <dir>      Creates the <dir> on the device.");
        System.err.println("    mv <from> <to>   Moves (renames) the remote path <from> to <to>.");
        System.err.println("    upload <localpath> <remotedir>\n                   Uploads the local file or dir at <localpath> to the remote dir <remotedir>.");
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        String deviceId = null;
        String action = null;
        int index = 0;
        try {
            action = args[index++];
            if (action.matches("[0-9a-f]{40}")) {
                deviceId = action;
                action = args[index++];
            }
            if (!action.matches("deviceinfo|rm|ls|mkdir|mv|upload")) {
                System.err.println("Unknown action: " + action);
                AfcClient.printUsageAndExit();
            }
            if (deviceId == null && deviceId == null) {
                String[] udids = IDevice.listUdids();
                if (udids.length == 0) {
                    System.err.println("No device connected");
                    return;
                }
                if (udids.length > 1) {
                    System.err.println("More than 1 device connected (" + Arrays.asList(udids) + "). Using " + udids[0]);
                }
                deviceId = udids[0];
            }
            try (IDevice device = new IDevice(deviceId);
                 LockdowndClient lockdowndClient = new LockdowndClient(device, AfcClient.class.getSimpleName(), true);){
                LockdowndServiceDescriptor service = lockdowndClient.startService(SERVICE_NAME);
                try (AfcClient client = new AfcClient(device, service);){
                    boolean recurse = false;
                    switch (action) {
                        case "deviceinfo": {
                            System.out.println(client.getDeviceInfo());
                            return;
                        }
                        case "rm": {
                            if ("-r".equals(args[index])) {
                                recurse = true;
                                ++index;
                            }
                            client.removePath(args[index], recurse);
                            return;
                        }
                        case "ls": {
                            if ("-r".equals(args[index])) {
                                recurse = true;
                                ++index;
                            }
                            client.list(args[index], recurse);
                            return;
                        }
                        case "mkdir": {
                            client.makeDirectory(args[index]);
                            return;
                        }
                        case "mv": {
                            client.renamePath(args[index++], args[index]);
                            return;
                        }
                        case "upload": {
                            client.upload(new File(args[index++]), args[index], new UploadProgressCallback(){

                                @Override
                                public void progress(File path, int percentComplete) {
                                    System.out.format("[%3d%%] Uploading %s\n", percentComplete, path);
                                }

                                @Override
                                public void success() {
                                    System.out.format("[100%%] Upload done!\n", new Object[0]);
                                }

                                @Override
                                public void error(String message) {
                                    System.out.format("Error: %s\n", message);
                                }
                            });
                            return;
                        }
                    }
                    return;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            AfcClient.printUsageAndExit();
        }
    }

    public static interface UploadProgressCallback {
        public void progress(File var1, int var2);

        public void success();

        public void error(String var1);
    }
}

