/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless;

import com.gocardless.http.HttpClient;
import com.gocardless.http.LoggingInterceptor;
import com.gocardless.services.BankAuthorisationService;
import com.gocardless.services.BankDetailsLookupService;
import com.gocardless.services.BillingRequestFlowService;
import com.gocardless.services.BillingRequestService;
import com.gocardless.services.BillingRequestTemplateService;
import com.gocardless.services.BlockService;
import com.gocardless.services.CreditorBankAccountService;
import com.gocardless.services.CreditorService;
import com.gocardless.services.CurrencyExchangeRateService;
import com.gocardless.services.CustomerBankAccountService;
import com.gocardless.services.CustomerNotificationService;
import com.gocardless.services.CustomerService;
import com.gocardless.services.EventService;
import com.gocardless.services.InstalmentScheduleService;
import com.gocardless.services.InstitutionService;
import com.gocardless.services.MandateImportEntryService;
import com.gocardless.services.MandateImportService;
import com.gocardless.services.MandatePdfService;
import com.gocardless.services.MandateService;
import com.gocardless.services.PayerAuthorisationService;
import com.gocardless.services.PaymentService;
import com.gocardless.services.PayoutItemService;
import com.gocardless.services.PayoutService;
import com.gocardless.services.RedirectFlowService;
import com.gocardless.services.RefundService;
import com.gocardless.services.ScenarioSimulatorService;
import com.gocardless.services.SubscriptionService;
import com.gocardless.services.TaxRateService;
import com.gocardless.services.WebhookService;
import com.google.common.annotations.VisibleForTesting;
import java.net.Proxy;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class GoCardlessClient {
    private final HttpClient httpClient;
    private final BankAuthorisationService bankAuthorisations;
    private final BankDetailsLookupService bankDetailsLookups;
    private final BillingRequestService billingRequests;
    private final BillingRequestFlowService billingRequestFlows;
    private final BillingRequestTemplateService billingRequestTemplates;
    private final BlockService blocks;
    private final CreditorService creditors;
    private final CreditorBankAccountService creditorBankAccounts;
    private final CurrencyExchangeRateService currencyExchangeRates;
    private final CustomerService customers;
    private final CustomerBankAccountService customerBankAccounts;
    private final CustomerNotificationService customerNotifications;
    private final EventService events;
    private final InstalmentScheduleService instalmentSchedules;
    private final InstitutionService institutions;
    private final MandateService mandates;
    private final MandateImportService mandateImports;
    private final MandateImportEntryService mandateImportEntries;
    private final MandatePdfService mandatePdfs;
    private final PayerAuthorisationService payerAuthorisations;
    private final PaymentService payments;
    private final PayoutService payouts;
    private final PayoutItemService payoutItems;
    private final RedirectFlowService redirectFlows;
    private final RefundService refunds;
    private final ScenarioSimulatorService scenarioSimulators;
    private final SubscriptionService subscriptions;
    private final TaxRateService taxRates;
    private final WebhookService webhooks;

    private GoCardlessClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.bankAuthorisations = new BankAuthorisationService(httpClient);
        this.bankDetailsLookups = new BankDetailsLookupService(httpClient);
        this.billingRequests = new BillingRequestService(httpClient);
        this.billingRequestFlows = new BillingRequestFlowService(httpClient);
        this.billingRequestTemplates = new BillingRequestTemplateService(httpClient);
        this.blocks = new BlockService(httpClient);
        this.creditors = new CreditorService(httpClient);
        this.creditorBankAccounts = new CreditorBankAccountService(httpClient);
        this.currencyExchangeRates = new CurrencyExchangeRateService(httpClient);
        this.customers = new CustomerService(httpClient);
        this.customerBankAccounts = new CustomerBankAccountService(httpClient);
        this.customerNotifications = new CustomerNotificationService(httpClient);
        this.events = new EventService(httpClient);
        this.instalmentSchedules = new InstalmentScheduleService(httpClient);
        this.institutions = new InstitutionService(httpClient);
        this.mandates = new MandateService(httpClient);
        this.mandateImports = new MandateImportService(httpClient);
        this.mandateImportEntries = new MandateImportEntryService(httpClient);
        this.mandatePdfs = new MandatePdfService(httpClient);
        this.payerAuthorisations = new PayerAuthorisationService(httpClient);
        this.payments = new PaymentService(httpClient);
        this.payouts = new PayoutService(httpClient);
        this.payoutItems = new PayoutItemService(httpClient);
        this.redirectFlows = new RedirectFlowService(httpClient);
        this.refunds = new RefundService(httpClient);
        this.scenarioSimulators = new ScenarioSimulatorService(httpClient);
        this.subscriptions = new SubscriptionService(httpClient);
        this.taxRates = new TaxRateService(httpClient);
        this.webhooks = new WebhookService(httpClient);
    }

    public BankAuthorisationService bankAuthorisations() {
        return this.bankAuthorisations;
    }

    public BankDetailsLookupService bankDetailsLookups() {
        return this.bankDetailsLookups;
    }

    public BillingRequestService billingRequests() {
        return this.billingRequests;
    }

    public BillingRequestFlowService billingRequestFlows() {
        return this.billingRequestFlows;
    }

    public BillingRequestTemplateService billingRequestTemplates() {
        return this.billingRequestTemplates;
    }

    public BlockService blocks() {
        return this.blocks;
    }

    public CreditorService creditors() {
        return this.creditors;
    }

    public CreditorBankAccountService creditorBankAccounts() {
        return this.creditorBankAccounts;
    }

    public CurrencyExchangeRateService currencyExchangeRates() {
        return this.currencyExchangeRates;
    }

    public CustomerService customers() {
        return this.customers;
    }

    public CustomerBankAccountService customerBankAccounts() {
        return this.customerBankAccounts;
    }

    public CustomerNotificationService customerNotifications() {
        return this.customerNotifications;
    }

    public EventService events() {
        return this.events;
    }

    public InstalmentScheduleService instalmentSchedules() {
        return this.instalmentSchedules;
    }

    public InstitutionService institutions() {
        return this.institutions;
    }

    public MandateService mandates() {
        return this.mandates;
    }

    public MandateImportService mandateImports() {
        return this.mandateImports;
    }

    public MandateImportEntryService mandateImportEntries() {
        return this.mandateImportEntries;
    }

    public MandatePdfService mandatePdfs() {
        return this.mandatePdfs;
    }

    public PayerAuthorisationService payerAuthorisations() {
        return this.payerAuthorisations;
    }

    public PaymentService payments() {
        return this.payments;
    }

    public PayoutService payouts() {
        return this.payouts;
    }

    public PayoutItemService payoutItems() {
        return this.payoutItems;
    }

    public RedirectFlowService redirectFlows() {
        return this.redirectFlows;
    }

    public RefundService refunds() {
        return this.refunds;
    }

    public ScenarioSimulatorService scenarioSimulators() {
        return this.scenarioSimulators;
    }

    public SubscriptionService subscriptions() {
        return this.subscriptions;
    }

    public TaxRateService taxRates() {
        return this.taxRates;
    }

    public WebhookService webhooks() {
        return this.webhooks;
    }

    public static Builder newBuilder(String accessToken) {
        return new Builder(accessToken);
    }

    @VisibleForTesting
    HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static enum Environment {
        LIVE,
        SANDBOX;


        private String getBaseUrl() {
            switch (this) {
                case LIVE: {
                    return "https://api.gocardless.com";
                }
                case SANDBOX: {
                    return "https://api-sandbox.gocardless.com";
                }
            }
            throw new IllegalArgumentException("Unknown environment:" + (Object)((Object)this));
        }
    }

    public static final class Builder {
        private final String accessToken;
        private String baseUrl;
        private Proxy proxy;
        private SSLSocketFactory sslSocketFactory;
        private X509TrustManager trustManager;
        private boolean errorOnIdempotencyConflict;
        private int maxNoOfRetries = 3;
        private long waitBetweenRetriesInMilliSeconds = 500L;

        private Builder(String accessToken) {
            this.accessToken = accessToken;
            this.withEnvironment(Environment.LIVE);
        }

        public Builder withBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder withEnvironment(Environment environment) {
            return this.withBaseUrl(environment.getBaseUrl());
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withSslSocketFactoryAndTrustManager(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
            return this;
        }

        public Builder withErrorOnIdempotencyConflict(boolean errorOnIdempotencyConflict) {
            this.errorOnIdempotencyConflict = errorOnIdempotencyConflict;
            return this;
        }

        public Builder withMaxNoOfRetries(int maxNoOfRetries) {
            if (maxNoOfRetries > this.maxNoOfRetries) {
                return this;
            }
            this.maxNoOfRetries = maxNoOfRetries;
            return this;
        }

        public Builder withWaitBetweenRetriesInMilliSeconds(long waitBetweenRetriesInMilliSeconds) {
            this.waitBetweenRetriesInMilliSeconds = waitBetweenRetriesInMilliSeconds;
            return this;
        }

        public GoCardlessClient build() {
            OkHttpClient.Builder rawClientBuilder = new OkHttpClient.Builder().proxy(this.proxy);
            if (this.sslSocketFactory != null && this.trustManager != null) {
                rawClientBuilder.sslSocketFactory(this.sslSocketFactory, this.trustManager);
            }
            OkHttpClient rawClient = rawClientBuilder.addInterceptor((Interceptor)new LoggingInterceptor()).build();
            HttpClient client = new HttpClient(this.accessToken, this.baseUrl, rawClient, this.errorOnIdempotencyConflict, this.maxNoOfRetries, this.waitBetweenRetriesInMilliSeconds);
            return new GoCardlessClient(client);
        }
    }
}

