/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless;

import com.gocardless.errors.InvalidSignatureException;
import com.gocardless.http.WebhookParser;
import com.gocardless.resources.Event;
import java.security.MessageDigest;
import java.util.List;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class Webhook {
    private Webhook() {
    }

    public static List<Event> parse(String requestBody, String signatureHeader, String webhookEndpointSecret) {
        if (Webhook.isValidSignature(requestBody, signatureHeader, webhookEndpointSecret)) {
            return WebhookParser.parse(requestBody);
        }
        throw new InvalidSignatureException();
    }

    public static boolean isValidSignature(String requestBody, String signatureHeader, String webhookEndpointSecret) {
        String computedSignature = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, webhookEndpointSecret).hmacHex(requestBody);
        return MessageDigest.isEqual(signatureHeader.getBytes(), computedSignature.getBytes());
    }
}

