/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.errors;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ApiError {
    private static final Joiner JOINER = Joiner.on((String)" ").skipNulls();
    private final String message;
    private final String reason;
    private final String field;
    private final String requestPointer;
    private final Map<String, String> links;

    private ApiError(String message, String reason, String field, String requestPointer, Map<String, String> links) {
        this.message = message;
        this.reason = reason;
        this.field = field;
        this.requestPointer = requestPointer;
        this.links = links;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReason() {
        return this.reason;
    }

    public String getField() {
        return this.field;
    }

    public String getRequestPointer() {
        return this.requestPointer;
    }

    public Map<String, String> getLinks() {
        if (this.links == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.links);
    }

    public String toString() {
        return JOINER.join((Object)this.field, (Object)this.message, new Object[0]);
    }
}

