/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.errors;

import com.gocardless.errors.ApiError;
import com.gocardless.errors.ErrorType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ApiErrorResponse {
    private static final Joiner JOINER = Joiner.on((String)", ");
    private final String message;
    private final ErrorType type;
    private final String documentationUrl;
    private final String requestId;
    private final int code;
    private final List<ApiError> errors;

    private ApiErrorResponse(String message, ErrorType type, String documentationUrl, String requestId, int code, List<ApiError> errors) {
        this.message = message;
        this.type = type;
        this.documentationUrl = documentationUrl;
        this.requestId = requestId;
        this.code = code;
        this.errors = errors;
    }

    String getMessage() {
        return this.message;
    }

    ErrorType getType() {
        return this.type;
    }

    String getDocumentationUrl() {
        return this.documentationUrl;
    }

    String getRequestId() {
        return this.requestId;
    }

    int getCode() {
        return this.code;
    }

    List<ApiError> getErrors() {
        if (this.errors == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.errors);
    }

    public String toString() {
        if (this.errors == null || this.errors.isEmpty()) {
            return this.message;
        }
        return JOINER.join(this.errors);
    }
}

