/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.errors;

import com.gocardless.errors.ApiErrorResponse;
import com.gocardless.errors.AuthenticationException;
import com.gocardless.errors.GoCardlessApiException;
import com.gocardless.errors.GoCardlessInternalException;
import com.gocardless.errors.InvalidApiUsageException;
import com.gocardless.errors.InvalidStateException;
import com.gocardless.errors.PermissionException;
import com.gocardless.errors.RateLimitException;
import com.gocardless.errors.ValidationFailedException;

public class GoCardlessErrorMapper {
    public static GoCardlessApiException toException(ApiErrorResponse error) {
        switch (error.getCode()) {
            case 401: {
                return new AuthenticationException(error);
            }
            case 403: {
                return new PermissionException(error);
            }
            case 429: {
                return new RateLimitException(error);
            }
        }
        switch (error.getType()) {
            case GOCARDLESS: {
                return new GoCardlessInternalException(error);
            }
            case INVALID_API_USAGE: {
                return new InvalidApiUsageException(error);
            }
            case INVALID_STATE: {
                return new InvalidStateException(error);
            }
            case VALIDATION_FAILED: {
                return new ValidationFailedException(error);
            }
        }
        throw new IllegalStateException("Unknown error type: " + (Object)((Object)error.getType()));
    }
}

