/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.gocardless.http.HttpClient;
import com.gocardless.http.ResponseParser;
import com.gocardless.http.UrlFormatter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import okhttp3.HttpUrl;

abstract class ApiRequest<T> {
    private final transient HttpClient httpClient;
    private final transient Map<String, String> customHeaders;

    ApiRequest(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.customHeaders = Maps.newHashMap();
    }

    HttpUrl getUrl(UrlFormatter urlFormatter) {
        return urlFormatter.formatUrl(this.getPathTemplate(), this.getPathParams(), this.getQueryParams());
    }

    protected Map<String, String> getPathParams() {
        return ImmutableMap.of();
    }

    protected Map<String, Object> getQueryParams() {
        return ImmutableMap.of();
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected String getRequestEnvelope() {
        return this.getEnvelope();
    }

    protected final void addHeader(String headerName, String headerValue) {
        this.customHeaders.put(headerName, headerValue);
    }

    protected final Map<String, String> getCustomHeaders() {
        return ImmutableMap.copyOf(this.customHeaders);
    }

    protected Map<String, String> getHeaders() {
        return this.getCustomHeaders();
    }

    protected abstract String getPathTemplate();

    protected abstract String getMethod();

    protected abstract String getEnvelope();

    protected abstract boolean hasBody();

    protected abstract T parseResponse(String var1, ResponseParser var2);
}

