/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;

public class ApiResponse<T> {
    private final T resource;
    private final int statusCode;
    private final Multimap<String, String> headers;

    public ApiResponse(T resource, int statusCode, Map<String, List<String>> headers) {
        this.resource = resource;
        this.statusCode = statusCode;
        this.headers = ApiResponse.buildHeaderMap(headers);
    }

    public T getResource() {
        return this.resource;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    private static Multimap<String, String> buildHeaderMap(Map<String, List<String>> headers) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            builder.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.build();
    }
}

