/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;

public class GCEnumTypeAdapterFactory
implements TypeAdapterFactory {
    private static final String UNKNOWN = "unknown";

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (!rawType.isEnum()) {
            return null;
        }
        final HashMap nameToConstant = new HashMap();
        final HashMap constantToName = new HashMap();
        try {
            for (Object constant : rawType.getEnumConstants()) {
                String name = ((Enum)constant).name();
                SerializedName annotation = rawType.getField(name).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    name = annotation.value();
                    for (String alternate : annotation.alternate()) {
                        nameToConstant.put(alternate, constant);
                    }
                } else {
                    name = constant.toString();
                }
                nameToConstant.put(name, constant);
                constantToName.put(constant, name);
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                out.value(value == null ? null : (String)constantToName.get(value));
            }

            public T read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                String input = in.nextString();
                if (!nameToConstant.containsKey(input)) {
                    return nameToConstant.get(GCEnumTypeAdapterFactory.UNKNOWN);
                }
                return nameToConstant.get(input);
            }
        };
    }
}

