/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.gocardless.GoCardlessException;
import com.gocardless.errors.GoCardlessInternalException;
import com.gocardless.http.ApiRequest;
import com.gocardless.http.ApiResponse;
import com.gocardless.http.GoCardlessNetworkException;
import com.gocardless.http.GsonFactory;
import com.gocardless.http.RequestWriter;
import com.gocardless.http.ResponseParser;
import com.gocardless.http.UrlFormatter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClient {
    public static final int MAX_RETRIES = 3;
    public static final long WAIT_BETWEEN_RETRIES_IN_MILLI_SECONDS = 500L;
    private static final String DISALLOWED_USER_AGENT_CHARACTERS = "[^\\w!#$%&'\\*\\+\\-\\.\\^`\\|~]";
    private static final String USER_AGENT = String.format("gocardless-pro-java/5.4.0 java/%s %s/%s %s/%s", HttpClient.cleanUserAgentToken(System.getProperty("java.vm.specification.version")), HttpClient.cleanUserAgentToken(System.getProperty("java.vm.name")), HttpClient.cleanUserAgentToken(System.getProperty("java.version")), HttpClient.cleanUserAgentToken(System.getProperty("os.name")), HttpClient.cleanUserAgentToken(System.getProperty("os.version")));
    private static final RequestBody EMPTY_BODY = RequestBody.create(null, (byte[])new byte[0]);
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json");
    private static final Map<String, String> HEADERS;
    private final OkHttpClient rawClient;
    private final UrlFormatter urlFormatter;
    private final ResponseParser responseParser;
    private final RequestWriter requestWriter;
    private final String credentials;
    private final boolean errorOnIdempotencyConflict;
    private final int maxNoOfRetries;
    private final long waitBetweenRetriesInMilliSeconds;

    public HttpClient(String accessToken, String baseUrl, OkHttpClient rawClient, boolean errorOnIdempotencyConflict, int maxNoOfRetries, long waitBetweenRetriesInMilliSeconds) {
        this.rawClient = rawClient;
        this.urlFormatter = new UrlFormatter(baseUrl);
        Gson gson = GsonFactory.build();
        this.responseParser = new ResponseParser(gson);
        this.requestWriter = new RequestWriter(gson);
        this.credentials = String.format("Bearer %s", accessToken);
        this.errorOnIdempotencyConflict = errorOnIdempotencyConflict;
        this.maxNoOfRetries = maxNoOfRetries;
        this.waitBetweenRetriesInMilliSeconds = waitBetweenRetriesInMilliSeconds;
    }

    public boolean isErrorOnIdempotencyConflict() {
        return this.errorOnIdempotencyConflict;
    }

    @VisibleForTesting
    public int getMaxNoOfRetries() {
        return this.maxNoOfRetries;
    }

    <T> T execute(ApiRequest<T> apiRequest) {
        Request request = this.buildRequest(apiRequest);
        Response response = this.execute(request);
        return this.parseResponseBody(apiRequest, response);
    }

    <T> ApiResponse<T> executeWrapped(ApiRequest<T> apiRequest) {
        Request request = this.buildRequest(apiRequest);
        Response response = this.execute(request);
        T resource = this.parseResponseBody(apiRequest, response);
        return new ApiResponse<T>(resource, response.code(), response.headers().toMultimap());
    }

    <T> T executeWithRetries(final ApiRequest<T> apiRequest) {
        Retryer retrier = RetryerBuilder.newBuilder().retryIfExceptionOfType(GoCardlessNetworkException.class).retryIfExceptionOfType(GoCardlessInternalException.class).withWaitStrategy(WaitStrategies.fixedWait((long)this.waitBetweenRetriesInMilliSeconds, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)this.maxNoOfRetries)).build();
        Callable executeOnce = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return HttpClient.this.execute(apiRequest);
            }
        };
        try {
            return (T)retrier.call(executeOnce);
        }
        catch (RetryException | ExecutionException e) {
            Throwable cause = e.getCause();
            throw Throwables.propagate((Throwable)cause);
        }
    }

    private <T> Request buildRequest(ApiRequest<T> apiRequest) {
        HttpUrl url = apiRequest.getUrl(this.urlFormatter);
        Request.Builder request = new Request.Builder().url(url).headers(Headers.of(apiRequest.getHeaders())).header("Authorization", this.credentials).header("User-Agent", USER_AGENT).method(apiRequest.getMethod(), this.getBody(apiRequest));
        for (Map.Entry<String, String> entry : HEADERS.entrySet()) {
            request = request.header(entry.getKey(), entry.getValue());
        }
        return request.build();
    }

    private <T> RequestBody getBody(ApiRequest<T> request) {
        if (!request.hasBody()) {
            if (request.getMethod().equals("GET")) {
                return null;
            }
            return EMPTY_BODY;
        }
        String json = this.requestWriter.write(request, request.getRequestEnvelope());
        return RequestBody.create((MediaType)MEDIA_TYPE, (String)json);
    }

    private Response execute(Request request) {
        Response response;
        try {
            response = this.rawClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new GoCardlessNetworkException("Failed to execute request", e);
        }
        if (!response.isSuccessful()) {
            throw this.handleErrorResponse(response);
        }
        return response;
    }

    private <T> T parseResponseBody(ApiRequest<T> request, Response response) {
        try {
            String responseBody = response.body().string();
            return request.parseResponse(responseBody, this.responseParser);
        }
        catch (IOException e) {
            throw new GoCardlessNetworkException("Failed to read response body", e);
        }
    }

    private GoCardlessException handleErrorResponse(Response response) {
        try {
            String responseBody = response.body().string();
            return this.responseParser.parseError(responseBody);
        }
        catch (IOException e) {
            throw new GoCardlessNetworkException("Failed to read response body", e);
        }
    }

    private static String cleanUserAgentToken(String s) {
        return s.replaceAll(DISALLOWED_USER_AGENT_CHARACTERS, "_");
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"GoCardless-Version", (Object)"2015-07-06");
        builder.put((Object)"GoCardless-Client-Library", (Object)"gocardless-pro-java");
        builder.put((Object)"GoCardless-Client-Version", (Object)"5.4.0");
        HEADERS = builder.build();
    }
}

