/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.gocardless.errors.ApiError;
import com.gocardless.errors.InvalidStateException;
import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.PostRequest;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.UUID;

public abstract class IdempotentPostRequest<T>
extends PostRequest<T> {
    private static final Predicate<ApiError> CONFLICT_ERROR = new Predicate<ApiError>(){

        public boolean apply(ApiError error) {
            return error.getReason().equals("idempotent_creation_conflict");
        }
    };
    private transient String idempotencyKey;

    protected IdempotentPostRequest(HttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public T execute() {
        try {
            return this.getHttpClient().executeWithRetries(this);
        }
        catch (InvalidStateException e) {
            Optional conflictError = Iterables.tryFind(e.getErrors(), CONFLICT_ERROR);
            if (conflictError.isPresent() && !this.getHttpClient().isErrorOnIdempotencyConflict()) {
                String id = ((ApiError)conflictError.get()).getLinks().get("conflicting_resource_id");
                return this.handleConflict(this.getHttpClient(), id).execute();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    protected final ImmutableMap<String, String> getHeaders() {
        String requestIdempotencyKey;
        if (this.idempotencyKey == null) {
            requestIdempotencyKey = UUID.randomUUID().toString();
            this.setIdempotencyKey(requestIdempotencyKey);
        } else {
            requestIdempotencyKey = this.idempotencyKey;
        }
        return ImmutableMap.builder().put((Object)"Idempotency-Key", (Object)requestIdempotencyKey).putAll(super.getHeaders()).build();
    }

    protected abstract GetRequest<T> handleConflict(HttpClient var1, String var2);
}

