/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.gocardless.http.ApiRequest;
import com.gocardless.http.ApiResponse;
import com.gocardless.http.HttpClient;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PaginatingIterable;
import com.gocardless.http.ResponseParser;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public abstract class ListRequest<S, T>
extends ApiRequest<ListResponse<T>> {
    private final transient ListRequestExecutor<S, T> executor;
    private final transient String method;
    private String after;
    private String before;
    private Integer limit;

    protected ListRequest(HttpClient httpClient, ListRequestExecutor<S, T> executor) {
        this(httpClient, executor, "GET");
    }

    protected ListRequest(HttpClient httpClient, ListRequestExecutor<S, T> executor, String method) {
        super(httpClient);
        this.method = method;
        this.executor = executor;
    }

    public S execute() {
        return this.executor.execute(this, this.getHttpClient());
    }

    public ApiResponse<S> executeWrapped() {
        return this.executor.executeWrapped(this, this.getHttpClient());
    }

    @Override
    protected ListResponse<T> parseResponse(String responseBody, ResponseParser responseParser) {
        return responseParser.parsePage(responseBody, this.getEnvelope(), this.getTypeToken());
    }

    @Override
    protected final String getMethod() {
        return this.method;
    }

    @Override
    protected boolean hasBody() {
        return false;
    }

    @Override
    protected Map<String, Object> getQueryParams() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        if (this.after != null) {
            params.put((Object)"after", (Object)this.after);
        }
        if (this.before != null) {
            params.put((Object)"before", (Object)this.before);
        }
        if (this.limit != null) {
            params.put((Object)"limit", (Object)this.limit);
        }
        return params.build();
    }

    protected abstract TypeToken<List<T>> getTypeToken();

    protected void setAfter(String after) {
        this.after = after;
    }

    protected void setBefore(String before) {
        this.before = before;
    }

    protected void setLimit(Integer limit) {
        this.limit = limit;
    }

    public static <T> ListRequestExecutor<ListResponse<T>, T> pagingExecutor() {
        return new ListRequestExecutor<ListResponse<T>, T>(){

            @Override
            public ListResponse<T> execute(ListRequest<ListResponse<T>, T> request, HttpClient client) {
                return (ListResponse)client.executeWithRetries(request);
            }

            @Override
            public ApiResponse<ListResponse<T>> executeWrapped(ListRequest<ListResponse<T>, T> request, HttpClient client) {
                return client.executeWrapped(request);
            }
        };
    }

    public static <T> ListRequestExecutor<Iterable<T>, T> iteratingExecutor() {
        return new ListRequestExecutor<Iterable<T>, T>(){

            @Override
            public Iterable<T> execute(ListRequest<Iterable<T>, T> request, HttpClient client) {
                return new PaginatingIterable(request, client);
            }

            @Override
            public ApiResponse<Iterable<T>> executeWrapped(ListRequest<Iterable<T>, T> request, HttpClient client) {
                throw new IllegalStateException("executeWrapped not available when iterating through list responses");
            }
        };
    }

    public static interface ListRequestExecutor<S, T> {
        public S execute(ListRequest<S, T> var1, HttpClient var2);

        public ApiResponse<S> executeWrapped(ListRequest<S, T> var1, HttpClient var2);
    }
}

