/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.gocardless.http.HttpClient;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.List;

class PaginatingIterator<T>
extends AbstractIterator<T> {
    private final ListRequest<?, T> request;
    private final HttpClient client;
    private List<T> items;
    private String nextCursor;

    PaginatingIterator(ListRequest<?, T> request, HttpClient client) {
        this.request = request;
        this.client = client;
        this.loadPage();
    }

    protected T computeNext() {
        if (this.items.isEmpty() && this.nextCursor != null) {
            this.loadPage();
        }
        if (this.items.isEmpty()) {
            return (T)this.endOfData();
        }
        T item = this.items.get(0);
        this.items.remove(0);
        return item;
    }

    private void loadPage() {
        this.request.setAfter(this.nextCursor);
        ListResponse response = (ListResponse)this.client.executeWithRetries(this.request);
        this.items = Lists.newArrayList(response.getItems());
        this.nextCursor = response.getAfter();
    }
}

