/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.gocardless.errors.ApiErrorResponse;
import com.gocardless.errors.GoCardlessApiException;
import com.gocardless.errors.GoCardlessErrorMapper;
import com.gocardless.errors.MalformedResponseException;
import com.gocardless.http.ListResponse;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.List;

final class ResponseParser {
    private final Gson gson;

    ResponseParser(Gson gson) {
        this.gson = gson;
    }

    <T> T parseSingle(String responseBody, String envelope, Class<T> clazz) {
        JsonElement json;
        try {
            json = new JsonParser().parse(responseBody);
        }
        catch (JsonSyntaxException e) {
            throw new MalformedResponseException(responseBody);
        }
        JsonObject object = json.getAsJsonObject().getAsJsonObject(envelope);
        return (T)this.gson.fromJson((JsonElement)object, clazz);
    }

    <T> ImmutableList<T> parseMultiple(String responseBody, String envelope, TypeToken<List<T>> clazz) {
        JsonObject json = new JsonParser().parse(responseBody).getAsJsonObject();
        JsonArray array = json.getAsJsonArray(envelope);
        List items = (List)this.gson.fromJson((JsonElement)array, clazz.getType());
        return ImmutableList.copyOf((Collection)items);
    }

    <T> ImmutableList<T> parseMultiple(JsonObject json, String envelope, TypeToken<List<T>> clazz) {
        JsonArray array = json.getAsJsonArray(envelope);
        List items = (List)this.gson.fromJson((JsonElement)array, clazz.getType());
        return ImmutableList.copyOf((Collection)items);
    }

    <T> ListResponse<T> parsePage(String responseBody, String envelope, TypeToken<List<T>> clazz) {
        JsonObject json = new JsonParser().parse(responseBody).getAsJsonObject();
        ImmutableList<T> items = this.parseMultiple(json, envelope, clazz);
        JsonObject metaJson = json.getAsJsonObject("meta");
        ListResponse.Meta meta = (ListResponse.Meta)this.gson.fromJson((JsonElement)metaJson, ListResponse.Meta.class);
        return new ListResponse(ImmutableList.copyOf(items), meta);
    }

    GoCardlessApiException parseError(String responseBody) {
        ApiErrorResponse error = this.parseSingle(responseBody, "error", ApiErrorResponse.class);
        return GoCardlessErrorMapper.toException(error);
    }
}

