/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.http;

import com.google.common.net.UrlEscapers;
import java.util.Map;
import okhttp3.HttpUrl;

final class UrlFormatter {
    private final HttpUrl baseUrl;

    UrlFormatter(String baseUrl) {
        this.baseUrl = HttpUrl.parse((String)baseUrl);
    }

    HttpUrl formatUrl(String template, Map<String, String> pathParams, Map<String, Object> queryParams) {
        String path = template;
        for (Map.Entry<String, String> entry : pathParams.entrySet()) {
            path = path.replace(":" + entry.getKey(), UrlEscapers.urlPathSegmentEscaper().escape(entry.getValue()));
        }
        HttpUrl.Builder builder = this.baseUrl.resolve(path).newBuilder();
        for (Map.Entry<String, Object> param : queryParams.entrySet()) {
            builder.addQueryParameter(param.getKey(), param.getValue().toString());
        }
        return builder.build();
    }
}

