/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.PathParam;
import com.gocardless.resources.BankAuthorisation;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class BankAuthorisationService {
    private final HttpClient httpClient;

    public BankAuthorisationService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BankAuthorisationGetRequest get(String identity) {
        return new BankAuthorisationGetRequest(this.httpClient, identity);
    }

    public BankAuthorisationCreateRequest create() {
        return new BankAuthorisationCreateRequest(this.httpClient);
    }

    public static final class BankAuthorisationCreateRequest
    extends IdempotentPostRequest<BankAuthorisation> {
        private String authorisationType;
        private Links links;
        private String redirectUri;

        public BankAuthorisationCreateRequest withAuthorisationType(String authorisationType) {
            this.authorisationType = authorisationType;
            return this;
        }

        public BankAuthorisationCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public BankAuthorisationCreateRequest withLinksBillingRequest(String billingRequest) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withBillingRequest(billingRequest);
            return this;
        }

        public BankAuthorisationCreateRequest withLinksInstitution(String institution) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withInstitution(institution);
            return this;
        }

        public BankAuthorisationCreateRequest withRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public BankAuthorisationCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<BankAuthorisation> handleConflict(HttpClient httpClient, String id) {
            BankAuthorisationGetRequest request = new BankAuthorisationGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private BankAuthorisationCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public BankAuthorisationCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "bank_authorisations";
        }

        @Override
        protected String getEnvelope() {
            return "bank_authorisations";
        }

        @Override
        protected Class<BankAuthorisation> getResponseClass() {
            return BankAuthorisation.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String billingRequest;
            private String institution;

            public Links withBillingRequest(String billingRequest) {
                this.billingRequest = billingRequest;
                return this;
            }

            public Links withInstitution(String institution) {
                this.institution = institution;
                return this;
            }
        }
    }

    public static final class BankAuthorisationGetRequest
    extends GetRequest<BankAuthorisation> {
        @PathParam
        private final String identity;

        private BankAuthorisationGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BankAuthorisationGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "bank_authorisations/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "bank_authorisations";
        }

        @Override
        protected Class<BankAuthorisation> getResponseClass() {
            return BankAuthorisation.class;
        }
    }
}

