/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.HttpClient;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.BillingRequestFlow;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class BillingRequestFlowService {
    private final HttpClient httpClient;

    public BillingRequestFlowService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BillingRequestFlowCreateRequest create() {
        return new BillingRequestFlowCreateRequest(this.httpClient);
    }

    public BillingRequestFlowInitialiseRequest initialise(String identity) {
        return new BillingRequestFlowInitialiseRequest(this.httpClient, identity);
    }

    public static final class BillingRequestFlowInitialiseRequest
    extends PostRequest<BillingRequestFlow> {
        @PathParam
        private final String identity;

        private BillingRequestFlowInitialiseRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestFlowInitialiseRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_request_flows/:identity/actions/initialise";
        }

        @Override
        protected String getEnvelope() {
            return "billing_request_flows";
        }

        @Override
        protected Class<BillingRequestFlow> getResponseClass() {
            return BillingRequestFlow.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class BillingRequestFlowCreateRequest
    extends PostRequest<BillingRequestFlow> {
        private Boolean autoFulfil;
        private String exitUri;
        private Links links;
        private Boolean lockBankAccount;
        private Boolean lockCustomerDetails;
        private String redirectUri;
        private Boolean showRedirectButtons;

        public BillingRequestFlowCreateRequest withAutoFulfil(Boolean autoFulfil) {
            this.autoFulfil = autoFulfil;
            return this;
        }

        public BillingRequestFlowCreateRequest withExitUri(String exitUri) {
            this.exitUri = exitUri;
            return this;
        }

        public BillingRequestFlowCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public BillingRequestFlowCreateRequest withLinksBillingRequest(String billingRequest) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withBillingRequest(billingRequest);
            return this;
        }

        public BillingRequestFlowCreateRequest withLockBankAccount(Boolean lockBankAccount) {
            this.lockBankAccount = lockBankAccount;
            return this;
        }

        public BillingRequestFlowCreateRequest withLockCustomerDetails(Boolean lockCustomerDetails) {
            this.lockCustomerDetails = lockCustomerDetails;
            return this;
        }

        public BillingRequestFlowCreateRequest withRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public BillingRequestFlowCreateRequest withShowRedirectButtons(Boolean showRedirectButtons) {
            this.showRedirectButtons = showRedirectButtons;
            return this;
        }

        private BillingRequestFlowCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public BillingRequestFlowCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "billing_request_flows";
        }

        @Override
        protected String getEnvelope() {
            return "billing_request_flows";
        }

        @Override
        protected Class<BillingRequestFlow> getResponseClass() {
            return BillingRequestFlow.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String billingRequest;

            public Links withBillingRequest(String billingRequest) {
                this.billingRequest = billingRequest;
                return this;
            }
        }
    }
}

