/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.BillingRequest;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BillingRequestService {
    private final HttpClient httpClient;

    public BillingRequestService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BillingRequestListRequest<ListResponse<BillingRequest>> list() {
        return new BillingRequestListRequest<ListResponse<BillingRequest>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public BillingRequestListRequest<Iterable<BillingRequest>> all() {
        return new BillingRequestListRequest<Iterable<BillingRequest>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public BillingRequestCreateRequest create() {
        return new BillingRequestCreateRequest(this.httpClient);
    }

    public BillingRequestGetRequest get(String identity) {
        return new BillingRequestGetRequest(this.httpClient, identity);
    }

    public BillingRequestCollectCustomerDetailsRequest collectCustomerDetails(String identity) {
        return new BillingRequestCollectCustomerDetailsRequest(this.httpClient, identity);
    }

    public BillingRequestCollectBankAccountRequest collectBankAccount(String identity) {
        return new BillingRequestCollectBankAccountRequest(this.httpClient, identity);
    }

    public BillingRequestFulfilRequest fulfil(String identity) {
        return new BillingRequestFulfilRequest(this.httpClient, identity);
    }

    public BillingRequestConfirmPayerDetailsRequest confirmPayerDetails(String identity) {
        return new BillingRequestConfirmPayerDetailsRequest(this.httpClient, identity);
    }

    public BillingRequestCancelRequest cancel(String identity) {
        return new BillingRequestCancelRequest(this.httpClient, identity);
    }

    public BillingRequestNotifyRequest notify(String identity) {
        return new BillingRequestNotifyRequest(this.httpClient, identity);
    }

    public BillingRequestFallbackRequest fallback(String identity) {
        return new BillingRequestFallbackRequest(this.httpClient, identity);
    }

    public static final class BillingRequestFallbackRequest
    extends PostRequest<BillingRequest> {
        @PathParam
        private final String identity;

        private BillingRequestFallbackRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestFallbackRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity/actions/fallback";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class BillingRequestNotifyRequest
    extends PostRequest<BillingRequest> {
        @PathParam
        private final String identity;
        private String notificationType;
        private String redirectUri;

        public BillingRequestNotifyRequest withNotificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public BillingRequestNotifyRequest withRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        private BillingRequestNotifyRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestNotifyRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity/actions/notify";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class BillingRequestCancelRequest
    extends PostRequest<BillingRequest> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public BillingRequestCancelRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BillingRequestCancelRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private BillingRequestCancelRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestCancelRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity/actions/cancel";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class BillingRequestConfirmPayerDetailsRequest
    extends PostRequest<BillingRequest> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public BillingRequestConfirmPayerDetailsRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BillingRequestConfirmPayerDetailsRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private BillingRequestConfirmPayerDetailsRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestConfirmPayerDetailsRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity/actions/confirm_payer_details";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class BillingRequestFulfilRequest
    extends PostRequest<BillingRequest> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public BillingRequestFulfilRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BillingRequestFulfilRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private BillingRequestFulfilRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestFulfilRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity/actions/fulfil";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class BillingRequestCollectBankAccountRequest
    extends PostRequest<BillingRequest> {
        @PathParam
        private final String identity;
        private String accountHolderName;
        private String accountNumber;
        private String accountNumberSuffix;
        private AccountType accountType;
        private String bankCode;
        private String branchCode;
        private String countryCode;
        private String currency;
        private String iban;
        private Map<String, String> metadata;

        public BillingRequestCollectBankAccountRequest withAccountHolderName(String accountHolderName) {
            this.accountHolderName = accountHolderName;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withAccountNumberSuffix(String accountNumberSuffix) {
            this.accountNumberSuffix = accountNumberSuffix;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withAccountType(AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withBankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withBranchCode(String branchCode) {
            this.branchCode = branchCode;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withIban(String iban) {
            this.iban = iban;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BillingRequestCollectBankAccountRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private BillingRequestCollectBankAccountRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestCollectBankAccountRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity/actions/collect_bank_account";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }

        public static enum AccountType {
            SAVINGS,
            CHECKING,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static final class BillingRequestCollectCustomerDetailsRequest
    extends PostRequest<BillingRequest> {
        @PathParam
        private final String identity;
        private Customer customer;
        private CustomerBillingDetail customerBillingDetail;

        public BillingRequestCollectCustomerDetailsRequest withCustomer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerCompanyName(String companyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCompanyName(companyName);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerEmail(String email) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withEmail(email);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerFamilyName(String familyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withFamilyName(familyName);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerGivenName(String givenName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withGivenName(givenName);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerLanguage(String language) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withLanguage(language);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerMetadata(Map<String, String> metadata) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withMetadata(metadata);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerPhoneNumber(String phoneNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withPhoneNumber(phoneNumber);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetail(CustomerBillingDetail customerBillingDetail) {
            this.customerBillingDetail = customerBillingDetail;
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailAddressLine1(String addressLine1) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withAddressLine1(addressLine1);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailAddressLine2(String addressLine2) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withAddressLine2(addressLine2);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailAddressLine3(String addressLine3) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withAddressLine3(addressLine3);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailCity(String city) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withCity(city);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailCountryCode(String countryCode) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withCountryCode(countryCode);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailDanishIdentityNumber(String danishIdentityNumber) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withDanishIdentityNumber(danishIdentityNumber);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailPostalCode(String postalCode) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withPostalCode(postalCode);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailRegion(String region) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withRegion(region);
            return this;
        }

        public BillingRequestCollectCustomerDetailsRequest withCustomerBillingDetailSwedishIdentityNumber(String swedishIdentityNumber) {
            if (this.customerBillingDetail == null) {
                this.customerBillingDetail = new CustomerBillingDetail();
            }
            this.customerBillingDetail.withSwedishIdentityNumber(swedishIdentityNumber);
            return this;
        }

        private BillingRequestCollectCustomerDetailsRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestCollectCustomerDetailsRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity/actions/collect_customer_details";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }

        public static class CustomerBillingDetail {
            private String addressLine1;
            private String addressLine2;
            private String addressLine3;
            private String city;
            private String countryCode;
            private String danishIdentityNumber;
            private String postalCode;
            private String region;
            private String swedishIdentityNumber;

            public CustomerBillingDetail withAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            public CustomerBillingDetail withAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            public CustomerBillingDetail withAddressLine3(String addressLine3) {
                this.addressLine3 = addressLine3;
                return this;
            }

            public CustomerBillingDetail withCity(String city) {
                this.city = city;
                return this;
            }

            public CustomerBillingDetail withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public CustomerBillingDetail withDanishIdentityNumber(String danishIdentityNumber) {
                this.danishIdentityNumber = danishIdentityNumber;
                return this;
            }

            public CustomerBillingDetail withPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public CustomerBillingDetail withRegion(String region) {
                this.region = region;
                return this;
            }

            public CustomerBillingDetail withSwedishIdentityNumber(String swedishIdentityNumber) {
                this.swedishIdentityNumber = swedishIdentityNumber;
                return this;
            }
        }

        public static class Customer {
            private String companyName;
            private String email;
            private String familyName;
            private String givenName;
            private String language;
            private Map<String, String> metadata;
            private String phoneNumber;

            public Customer withCompanyName(String companyName) {
                this.companyName = companyName;
                return this;
            }

            public Customer withEmail(String email) {
                this.email = email;
                return this;
            }

            public Customer withFamilyName(String familyName) {
                this.familyName = familyName;
                return this;
            }

            public Customer withGivenName(String givenName) {
                this.givenName = givenName;
                return this;
            }

            public Customer withLanguage(String language) {
                this.language = language;
                return this;
            }

            public Customer withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Customer withPhoneNumber(String phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }
        }
    }

    public static final class BillingRequestGetRequest
    extends GetRequest<BillingRequest> {
        @PathParam
        private final String identity;

        private BillingRequestGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }
    }

    public static final class BillingRequestCreateRequest
    extends IdempotentPostRequest<BillingRequest> {
        private Boolean fallbackEnabled;
        private Links links;
        private MandateRequest mandateRequest;
        private Map<String, String> metadata;
        private PaymentRequest paymentRequest;

        public BillingRequestCreateRequest withFallbackEnabled(Boolean fallbackEnabled) {
            this.fallbackEnabled = fallbackEnabled;
            return this;
        }

        public BillingRequestCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public BillingRequestCreateRequest withLinksCreditor(String creditor) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCreditor(creditor);
            return this;
        }

        public BillingRequestCreateRequest withLinksCustomer(String customer) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCustomer(customer);
            return this;
        }

        public BillingRequestCreateRequest withLinksCustomerBankAccount(String customerBankAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCustomerBankAccount(customerBankAccount);
            return this;
        }

        public BillingRequestCreateRequest withMandateRequest(MandateRequest mandateRequest) {
            this.mandateRequest = mandateRequest;
            return this;
        }

        public BillingRequestCreateRequest withMandateRequestCurrency(String currency) {
            if (this.mandateRequest == null) {
                this.mandateRequest = new MandateRequest();
            }
            this.mandateRequest.withCurrency(currency);
            return this;
        }

        public BillingRequestCreateRequest withMandateRequestMetadata(Map<String, String> metadata) {
            if (this.mandateRequest == null) {
                this.mandateRequest = new MandateRequest();
            }
            this.mandateRequest.withMetadata(metadata);
            return this;
        }

        public BillingRequestCreateRequest withMandateRequestScheme(String scheme) {
            if (this.mandateRequest == null) {
                this.mandateRequest = new MandateRequest();
            }
            this.mandateRequest.withScheme(scheme);
            return this;
        }

        public BillingRequestCreateRequest withMandateRequestVerify(MandateRequest.Verify verify) {
            if (this.mandateRequest == null) {
                this.mandateRequest = new MandateRequest();
            }
            this.mandateRequest.withVerify(verify);
            return this;
        }

        public BillingRequestCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BillingRequestCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public BillingRequestCreateRequest withPaymentRequest(PaymentRequest paymentRequest) {
            this.paymentRequest = paymentRequest;
            return this;
        }

        public BillingRequestCreateRequest withPaymentRequestAmount(Integer amount) {
            if (this.paymentRequest == null) {
                this.paymentRequest = new PaymentRequest();
            }
            this.paymentRequest.withAmount(amount);
            return this;
        }

        public BillingRequestCreateRequest withPaymentRequestAppFee(Integer appFee) {
            if (this.paymentRequest == null) {
                this.paymentRequest = new PaymentRequest();
            }
            this.paymentRequest.withAppFee(appFee);
            return this;
        }

        public BillingRequestCreateRequest withPaymentRequestCurrency(String currency) {
            if (this.paymentRequest == null) {
                this.paymentRequest = new PaymentRequest();
            }
            this.paymentRequest.withCurrency(currency);
            return this;
        }

        public BillingRequestCreateRequest withPaymentRequestDescription(String description) {
            if (this.paymentRequest == null) {
                this.paymentRequest = new PaymentRequest();
            }
            this.paymentRequest.withDescription(description);
            return this;
        }

        public BillingRequestCreateRequest withPaymentRequestMetadata(Map<String, String> metadata) {
            if (this.paymentRequest == null) {
                this.paymentRequest = new PaymentRequest();
            }
            this.paymentRequest.withMetadata(metadata);
            return this;
        }

        public BillingRequestCreateRequest withPaymentRequestScheme(String scheme) {
            if (this.paymentRequest == null) {
                this.paymentRequest = new PaymentRequest();
            }
            this.paymentRequest.withScheme(scheme);
            return this;
        }

        public BillingRequestCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<BillingRequest> handleConflict(HttpClient httpClient, String id) {
            BillingRequestGetRequest request = new BillingRequestGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private BillingRequestCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public BillingRequestCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected Class<BillingRequest> getResponseClass() {
            return BillingRequest.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class PaymentRequest {
            private Integer amount;
            private Integer appFee;
            private String currency;
            private String description;
            private Map<String, String> metadata;
            private String scheme;

            public PaymentRequest withAmount(Integer amount) {
                this.amount = amount;
                return this;
            }

            public PaymentRequest withAppFee(Integer appFee) {
                this.appFee = appFee;
                return this;
            }

            public PaymentRequest withCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public PaymentRequest withDescription(String description) {
                this.description = description;
                return this;
            }

            public PaymentRequest withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public PaymentRequest withScheme(String scheme) {
                this.scheme = scheme;
                return this;
            }
        }

        public static class MandateRequest {
            private String currency;
            private Map<String, String> metadata;
            private String scheme;
            private Verify verify;

            public MandateRequest withCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public MandateRequest withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public MandateRequest withScheme(String scheme) {
                this.scheme = scheme;
                return this;
            }

            public MandateRequest withVerify(Verify verify) {
                this.verify = verify;
                return this;
            }

            public static enum Verify {
                MINIMUM,
                RECOMMENDED,
                WHEN_AVAILABLE,
                ALWAYS,
                UNKNOWN;


                public String toString() {
                    return this.name().toLowerCase();
                }
            }
        }

        public static class Links {
            private String creditor;
            private String customer;
            private String customerBankAccount;

            public Links withCreditor(String creditor) {
                this.creditor = creditor;
                return this;
            }

            public Links withCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public Links withCustomerBankAccount(String customerBankAccount) {
                this.customerBankAccount = customerBankAccount;
                return this;
            }
        }
    }

    public static final class BillingRequestListRequest<S>
    extends ListRequest<S, BillingRequest> {
        private String createdAt;
        private String customer;
        private String status;

        public BillingRequestListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public BillingRequestListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public BillingRequestListRequest<S> withCreatedAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public BillingRequestListRequest<S> withCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public BillingRequestListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public BillingRequestListRequest<S> withStatus(String status) {
            this.status = status;
            return this;
        }

        private BillingRequestListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, BillingRequest> executor) {
            super(httpClient, executor);
        }

        public BillingRequestListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.put((Object)"created_at", (Object)this.createdAt);
            }
            if (this.customer != null) {
                params.put((Object)"customer", (Object)this.customer);
            }
            if (this.status != null) {
                params.put((Object)"status", (Object)this.status);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_requests";
        }

        @Override
        protected String getEnvelope() {
            return "billing_requests";
        }

        @Override
        protected TypeToken<List<BillingRequest>> getTypeToken() {
            return new TypeToken<List<BillingRequest>>(){};
        }
    }
}

