/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.BillingRequestTemplate;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BillingRequestTemplateService {
    private final HttpClient httpClient;

    public BillingRequestTemplateService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BillingRequestTemplateListRequest<ListResponse<BillingRequestTemplate>> list() {
        return new BillingRequestTemplateListRequest<ListResponse<BillingRequestTemplate>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public BillingRequestTemplateListRequest<Iterable<BillingRequestTemplate>> all() {
        return new BillingRequestTemplateListRequest<Iterable<BillingRequestTemplate>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public BillingRequestTemplateGetRequest get(String identity) {
        return new BillingRequestTemplateGetRequest(this.httpClient, identity);
    }

    public BillingRequestTemplateCreateRequest create() {
        return new BillingRequestTemplateCreateRequest(this.httpClient);
    }

    public BillingRequestTemplateUpdateRequest update(String identity) {
        return new BillingRequestTemplateUpdateRequest(this.httpClient, identity);
    }

    public static final class BillingRequestTemplateUpdateRequest
    extends PutRequest<BillingRequestTemplate> {
        @PathParam
        private final String identity;
        private String mandateRequestCurrency;
        private Map<String, String> mandateRequestMetadata;
        private String mandateRequestScheme;
        private MandateRequestVerify mandateRequestVerify;
        private Map<String, String> metadata;
        private String name;
        private Integer paymentRequestAmount;
        private String paymentRequestCurrency;
        private String paymentRequestDescription;
        private Map<String, String> paymentRequestMetadata;
        private String paymentRequestScheme;
        private String redirectUri;

        public BillingRequestTemplateUpdateRequest withMandateRequestCurrency(String mandateRequestCurrency) {
            this.mandateRequestCurrency = mandateRequestCurrency;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withMandateRequestMetadata(Map<String, String> mandateRequestMetadata) {
            this.mandateRequestMetadata = mandateRequestMetadata;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withMandateRequestMetadata(String key, String value) {
            if (this.mandateRequestMetadata == null) {
                this.mandateRequestMetadata = new HashMap<String, String>();
            }
            this.mandateRequestMetadata.put(key, value);
            return this;
        }

        public BillingRequestTemplateUpdateRequest withMandateRequestScheme(String mandateRequestScheme) {
            this.mandateRequestScheme = mandateRequestScheme;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withMandateRequestVerify(MandateRequestVerify mandateRequestVerify) {
            this.mandateRequestVerify = mandateRequestVerify;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public BillingRequestTemplateUpdateRequest withName(String name) {
            this.name = name;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withPaymentRequestAmount(Integer paymentRequestAmount) {
            this.paymentRequestAmount = paymentRequestAmount;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withPaymentRequestCurrency(String paymentRequestCurrency) {
            this.paymentRequestCurrency = paymentRequestCurrency;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withPaymentRequestDescription(String paymentRequestDescription) {
            this.paymentRequestDescription = paymentRequestDescription;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withPaymentRequestMetadata(Map<String, String> paymentRequestMetadata) {
            this.paymentRequestMetadata = paymentRequestMetadata;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withPaymentRequestMetadata(String key, String value) {
            if (this.paymentRequestMetadata == null) {
                this.paymentRequestMetadata = new HashMap<String, String>();
            }
            this.paymentRequestMetadata.put(key, value);
            return this;
        }

        public BillingRequestTemplateUpdateRequest withPaymentRequestScheme(String paymentRequestScheme) {
            this.paymentRequestScheme = paymentRequestScheme;
            return this;
        }

        public BillingRequestTemplateUpdateRequest withRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        private BillingRequestTemplateUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestTemplateUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_request_templates/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "billing_request_templates";
        }

        @Override
        protected Class<BillingRequestTemplate> getResponseClass() {
            return BillingRequestTemplate.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static enum MandateRequestVerify {
            MINIMUM,
            RECOMMENDED,
            WHEN_AVAILABLE,
            ALWAYS,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static final class BillingRequestTemplateCreateRequest
    extends IdempotentPostRequest<BillingRequestTemplate> {
        private Links links;
        private String mandateRequestCurrency;
        private Map<String, String> mandateRequestMetadata;
        private String mandateRequestScheme;
        private MandateRequestVerify mandateRequestVerify;
        private Map<String, String> metadata;
        private String name;
        private Integer paymentRequestAmount;
        private String paymentRequestCurrency;
        private String paymentRequestDescription;
        private Map<String, String> paymentRequestMetadata;
        private String paymentRequestScheme;
        private String redirectUri;

        public BillingRequestTemplateCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public BillingRequestTemplateCreateRequest withLinksCreditor(String creditor) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCreditor(creditor);
            return this;
        }

        public BillingRequestTemplateCreateRequest withMandateRequestCurrency(String mandateRequestCurrency) {
            this.mandateRequestCurrency = mandateRequestCurrency;
            return this;
        }

        public BillingRequestTemplateCreateRequest withMandateRequestMetadata(Map<String, String> mandateRequestMetadata) {
            this.mandateRequestMetadata = mandateRequestMetadata;
            return this;
        }

        public BillingRequestTemplateCreateRequest withMandateRequestMetadata(String key, String value) {
            if (this.mandateRequestMetadata == null) {
                this.mandateRequestMetadata = new HashMap<String, String>();
            }
            this.mandateRequestMetadata.put(key, value);
            return this;
        }

        public BillingRequestTemplateCreateRequest withMandateRequestScheme(String mandateRequestScheme) {
            this.mandateRequestScheme = mandateRequestScheme;
            return this;
        }

        public BillingRequestTemplateCreateRequest withMandateRequestVerify(MandateRequestVerify mandateRequestVerify) {
            this.mandateRequestVerify = mandateRequestVerify;
            return this;
        }

        public BillingRequestTemplateCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public BillingRequestTemplateCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public BillingRequestTemplateCreateRequest withName(String name) {
            this.name = name;
            return this;
        }

        public BillingRequestTemplateCreateRequest withPaymentRequestAmount(Integer paymentRequestAmount) {
            this.paymentRequestAmount = paymentRequestAmount;
            return this;
        }

        public BillingRequestTemplateCreateRequest withPaymentRequestCurrency(String paymentRequestCurrency) {
            this.paymentRequestCurrency = paymentRequestCurrency;
            return this;
        }

        public BillingRequestTemplateCreateRequest withPaymentRequestDescription(String paymentRequestDescription) {
            this.paymentRequestDescription = paymentRequestDescription;
            return this;
        }

        public BillingRequestTemplateCreateRequest withPaymentRequestMetadata(Map<String, String> paymentRequestMetadata) {
            this.paymentRequestMetadata = paymentRequestMetadata;
            return this;
        }

        public BillingRequestTemplateCreateRequest withPaymentRequestMetadata(String key, String value) {
            if (this.paymentRequestMetadata == null) {
                this.paymentRequestMetadata = new HashMap<String, String>();
            }
            this.paymentRequestMetadata.put(key, value);
            return this;
        }

        public BillingRequestTemplateCreateRequest withPaymentRequestScheme(String paymentRequestScheme) {
            this.paymentRequestScheme = paymentRequestScheme;
            return this;
        }

        public BillingRequestTemplateCreateRequest withRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public BillingRequestTemplateCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<BillingRequestTemplate> handleConflict(HttpClient httpClient, String id) {
            BillingRequestTemplateGetRequest request = new BillingRequestTemplateGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private BillingRequestTemplateCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public BillingRequestTemplateCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "billing_request_templates";
        }

        @Override
        protected String getEnvelope() {
            return "billing_request_templates";
        }

        @Override
        protected Class<BillingRequestTemplate> getResponseClass() {
            return BillingRequestTemplate.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String creditor;

            public Links withCreditor(String creditor) {
                this.creditor = creditor;
                return this;
            }
        }

        public static enum MandateRequestVerify {
            MINIMUM,
            RECOMMENDED,
            WHEN_AVAILABLE,
            ALWAYS,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static final class BillingRequestTemplateGetRequest
    extends GetRequest<BillingRequestTemplate> {
        @PathParam
        private final String identity;

        private BillingRequestTemplateGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BillingRequestTemplateGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_request_templates/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "billing_request_templates";
        }

        @Override
        protected Class<BillingRequestTemplate> getResponseClass() {
            return BillingRequestTemplate.class;
        }
    }

    public static final class BillingRequestTemplateListRequest<S>
    extends ListRequest<S, BillingRequestTemplate> {
        public BillingRequestTemplateListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public BillingRequestTemplateListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public BillingRequestTemplateListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        private BillingRequestTemplateListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, BillingRequestTemplate> executor) {
            super(httpClient, executor);
        }

        public BillingRequestTemplateListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "billing_request_templates";
        }

        @Override
        protected String getEnvelope() {
            return "billing_request_templates";
        }

        @Override
        protected TypeToken<List<BillingRequestTemplate>> getTypeToken() {
            return new TypeToken<List<BillingRequestTemplate>>(){};
        }
    }
}

