/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.Block;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class BlockService {
    private final HttpClient httpClient;

    public BlockService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BlockCreateRequest create() {
        return new BlockCreateRequest(this.httpClient);
    }

    public BlockGetRequest get(String identity) {
        return new BlockGetRequest(this.httpClient, identity);
    }

    public BlockListRequest<ListResponse<Block>> list() {
        return new BlockListRequest<ListResponse<Block>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public BlockListRequest<Iterable<Block>> all() {
        return new BlockListRequest<Iterable<Block>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public BlockDisableRequest disable(String identity) {
        return new BlockDisableRequest(this.httpClient, identity);
    }

    public BlockEnableRequest enable(String identity) {
        return new BlockEnableRequest(this.httpClient, identity);
    }

    public BlockBlockByRefRequest<Iterable<Block>> blockByRef() {
        return new BlockBlockByRefRequest<Iterable<Block>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public static final class BlockBlockByRefRequest<S>
    extends ListRequest<S, Block> {
        private Boolean active;
        private String reasonDescription;
        private String reasonType;
        private String referenceType;
        private String referenceValue;

        public BlockBlockByRefRequest<S> withActive(Boolean active) {
            this.active = active;
            return this;
        }

        public BlockBlockByRefRequest<S> withReasonDescription(String reasonDescription) {
            this.reasonDescription = reasonDescription;
            return this;
        }

        public BlockBlockByRefRequest<S> withReasonType(String reasonType) {
            this.reasonType = reasonType;
            return this;
        }

        public BlockBlockByRefRequest<S> withReferenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public BlockBlockByRefRequest<S> withReferenceValue(String referenceValue) {
            this.referenceValue = referenceValue;
            return this;
        }

        private BlockBlockByRefRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Block> executor) {
            super(httpClient, executor, "POST");
        }

        public BlockBlockByRefRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "block_by_ref";
        }

        @Override
        protected String getEnvelope() {
            return "blocks";
        }

        @Override
        protected TypeToken<List<Block>> getTypeToken() {
            return new TypeToken<List<Block>>(){};
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class BlockEnableRequest
    extends PostRequest<Block> {
        @PathParam
        private final String identity;

        private BlockEnableRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BlockEnableRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "blocks/:identity/actions/enable";
        }

        @Override
        protected String getEnvelope() {
            return "blocks";
        }

        @Override
        protected Class<Block> getResponseClass() {
            return Block.class;
        }

        @Override
        protected boolean hasBody() {
            return false;
        }
    }

    public static final class BlockDisableRequest
    extends PostRequest<Block> {
        @PathParam
        private final String identity;

        private BlockDisableRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BlockDisableRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "blocks/:identity/actions/disable";
        }

        @Override
        protected String getEnvelope() {
            return "blocks";
        }

        @Override
        protected Class<Block> getResponseClass() {
            return Block.class;
        }

        @Override
        protected boolean hasBody() {
            return false;
        }
    }

    public static final class BlockListRequest<S>
    extends ListRequest<S, Block> {
        private String block;
        private String blockType;
        private String createdAt;
        private String reasonType;
        private String updatedAt;

        public BlockListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public BlockListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public BlockListRequest<S> withBlock(String block) {
            this.block = block;
            return this;
        }

        public BlockListRequest<S> withBlockType(String blockType) {
            this.blockType = blockType;
            return this;
        }

        public BlockListRequest<S> withCreatedAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public BlockListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public BlockListRequest<S> withReasonType(String reasonType) {
            this.reasonType = reasonType;
            return this;
        }

        public BlockListRequest<S> withUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        private BlockListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Block> executor) {
            super(httpClient, executor);
        }

        public BlockListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.block != null) {
                params.put((Object)"block", (Object)this.block);
            }
            if (this.blockType != null) {
                params.put((Object)"block_type", (Object)this.blockType);
            }
            if (this.createdAt != null) {
                params.put((Object)"created_at", (Object)this.createdAt);
            }
            if (this.reasonType != null) {
                params.put((Object)"reason_type", (Object)this.reasonType);
            }
            if (this.updatedAt != null) {
                params.put((Object)"updated_at", (Object)this.updatedAt);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "blocks";
        }

        @Override
        protected String getEnvelope() {
            return "blocks";
        }

        @Override
        protected TypeToken<List<Block>> getTypeToken() {
            return new TypeToken<List<Block>>(){};
        }
    }

    public static final class BlockGetRequest
    extends GetRequest<Block> {
        @PathParam
        private final String identity;

        private BlockGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public BlockGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "blocks/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "blocks";
        }

        @Override
        protected Class<Block> getResponseClass() {
            return Block.class;
        }
    }

    public static final class BlockCreateRequest
    extends IdempotentPostRequest<Block> {
        private Boolean active;
        private String blockType;
        private String reasonDescription;
        private String reasonType;
        private String resourceReference;

        public BlockCreateRequest withActive(Boolean active) {
            this.active = active;
            return this;
        }

        public BlockCreateRequest withBlockType(String blockType) {
            this.blockType = blockType;
            return this;
        }

        public BlockCreateRequest withReasonDescription(String reasonDescription) {
            this.reasonDescription = reasonDescription;
            return this;
        }

        public BlockCreateRequest withReasonType(String reasonType) {
            this.reasonType = reasonType;
            return this;
        }

        public BlockCreateRequest withResourceReference(String resourceReference) {
            this.resourceReference = resourceReference;
            return this;
        }

        public BlockCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<Block> handleConflict(HttpClient httpClient, String id) {
            BlockGetRequest request = new BlockGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private BlockCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public BlockCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "blocks";
        }

        @Override
        protected String getEnvelope() {
            return "blocks";
        }

        @Override
        protected Class<Block> getResponseClass() {
            return Block.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }
}

