/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.CreditorBankAccount;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreditorBankAccountService {
    private final HttpClient httpClient;

    public CreditorBankAccountService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CreditorBankAccountCreateRequest create() {
        return new CreditorBankAccountCreateRequest(this.httpClient);
    }

    public CreditorBankAccountListRequest<ListResponse<CreditorBankAccount>> list() {
        return new CreditorBankAccountListRequest<ListResponse<CreditorBankAccount>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public CreditorBankAccountListRequest<Iterable<CreditorBankAccount>> all() {
        return new CreditorBankAccountListRequest<Iterable<CreditorBankAccount>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public CreditorBankAccountGetRequest get(String identity) {
        return new CreditorBankAccountGetRequest(this.httpClient, identity);
    }

    public CreditorBankAccountDisableRequest disable(String identity) {
        return new CreditorBankAccountDisableRequest(this.httpClient, identity);
    }

    public static final class CreditorBankAccountDisableRequest
    extends PostRequest<CreditorBankAccount> {
        @PathParam
        private final String identity;

        private CreditorBankAccountDisableRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CreditorBankAccountDisableRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "creditor_bank_accounts/:identity/actions/disable";
        }

        @Override
        protected String getEnvelope() {
            return "creditor_bank_accounts";
        }

        @Override
        protected Class<CreditorBankAccount> getResponseClass() {
            return CreditorBankAccount.class;
        }

        @Override
        protected boolean hasBody() {
            return false;
        }
    }

    public static final class CreditorBankAccountGetRequest
    extends GetRequest<CreditorBankAccount> {
        @PathParam
        private final String identity;

        private CreditorBankAccountGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CreditorBankAccountGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "creditor_bank_accounts/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "creditor_bank_accounts";
        }

        @Override
        protected Class<CreditorBankAccount> getResponseClass() {
            return CreditorBankAccount.class;
        }
    }

    public static final class CreditorBankAccountListRequest<S>
    extends ListRequest<S, CreditorBankAccount> {
        private CreatedAt createdAt;
        private String creditor;
        private Boolean enabled;

        public CreditorBankAccountListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public CreditorBankAccountListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public CreditorBankAccountListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CreditorBankAccountListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public CreditorBankAccountListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public CreditorBankAccountListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public CreditorBankAccountListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public CreditorBankAccountListRequest<S> withCreditor(String creditor) {
            this.creditor = creditor;
            return this;
        }

        public CreditorBankAccountListRequest<S> withEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public CreditorBankAccountListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        private CreditorBankAccountListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, CreditorBankAccount> executor) {
            super(httpClient, executor);
        }

        public CreditorBankAccountListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.creditor != null) {
                params.put((Object)"creditor", (Object)this.creditor);
            }
            if (this.enabled != null) {
                params.put((Object)"enabled", (Object)this.enabled);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "creditor_bank_accounts";
        }

        @Override
        protected String getEnvelope() {
            return "creditor_bank_accounts";
        }

        @Override
        protected TypeToken<List<CreditorBankAccount>> getTypeToken() {
            return new TypeToken<List<CreditorBankAccount>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }
    }

    public static final class CreditorBankAccountCreateRequest
    extends IdempotentPostRequest<CreditorBankAccount> {
        private String accountHolderName;
        private String accountNumber;
        private AccountType accountType;
        private String bankCode;
        private String branchCode;
        private String countryCode;
        private String currency;
        private String iban;
        private Links links;
        private Map<String, String> metadata;
        private Boolean setAsDefaultPayoutAccount;

        public CreditorBankAccountCreateRequest withAccountHolderName(String accountHolderName) {
            this.accountHolderName = accountHolderName;
            return this;
        }

        public CreditorBankAccountCreateRequest withAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public CreditorBankAccountCreateRequest withAccountType(AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        public CreditorBankAccountCreateRequest withBankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public CreditorBankAccountCreateRequest withBranchCode(String branchCode) {
            this.branchCode = branchCode;
            return this;
        }

        public CreditorBankAccountCreateRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public CreditorBankAccountCreateRequest withCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public CreditorBankAccountCreateRequest withIban(String iban) {
            this.iban = iban;
            return this;
        }

        public CreditorBankAccountCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public CreditorBankAccountCreateRequest withLinksCreditor(String creditor) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCreditor(creditor);
            return this;
        }

        public CreditorBankAccountCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public CreditorBankAccountCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public CreditorBankAccountCreateRequest withSetAsDefaultPayoutAccount(Boolean setAsDefaultPayoutAccount) {
            this.setAsDefaultPayoutAccount = setAsDefaultPayoutAccount;
            return this;
        }

        public CreditorBankAccountCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<CreditorBankAccount> handleConflict(HttpClient httpClient, String id) {
            CreditorBankAccountGetRequest request = new CreditorBankAccountGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private CreditorBankAccountCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public CreditorBankAccountCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "creditor_bank_accounts";
        }

        @Override
        protected String getEnvelope() {
            return "creditor_bank_accounts";
        }

        @Override
        protected Class<CreditorBankAccount> getResponseClass() {
            return CreditorBankAccount.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String creditor;

            public Links withCreditor(String creditor) {
                this.creditor = creditor;
                return this;
            }
        }

        public static enum AccountType {
            SAVINGS,
            CHECKING,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

