/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.Creditor;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreditorService {
    private final HttpClient httpClient;

    public CreditorService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CreditorCreateRequest create() {
        return new CreditorCreateRequest(this.httpClient);
    }

    public CreditorListRequest<ListResponse<Creditor>> list() {
        return new CreditorListRequest<ListResponse<Creditor>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public CreditorListRequest<Iterable<Creditor>> all() {
        return new CreditorListRequest<Iterable<Creditor>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public CreditorGetRequest get(String identity) {
        return new CreditorGetRequest(this.httpClient, identity);
    }

    public CreditorUpdateRequest update(String identity) {
        return new CreditorUpdateRequest(this.httpClient, identity);
    }

    public static final class CreditorUpdateRequest
    extends PutRequest<Creditor> {
        @PathParam
        private final String identity;
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String city;
        private String countryCode;
        private Links links;
        private String name;
        private String postalCode;
        private String region;

        public CreditorUpdateRequest withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public CreditorUpdateRequest withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public CreditorUpdateRequest withAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public CreditorUpdateRequest withCity(String city) {
            this.city = city;
            return this;
        }

        public CreditorUpdateRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public CreditorUpdateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultAudPayoutAccount(String defaultAudPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultAudPayoutAccount(defaultAudPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultCadPayoutAccount(String defaultCadPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultCadPayoutAccount(defaultCadPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultDkkPayoutAccount(String defaultDkkPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultDkkPayoutAccount(defaultDkkPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultEurPayoutAccount(String defaultEurPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultEurPayoutAccount(defaultEurPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultGbpPayoutAccount(String defaultGbpPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultGbpPayoutAccount(defaultGbpPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultNzdPayoutAccount(String defaultNzdPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultNzdPayoutAccount(defaultNzdPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultSekPayoutAccount(String defaultSekPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultSekPayoutAccount(defaultSekPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withLinksDefaultUsdPayoutAccount(String defaultUsdPayoutAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withDefaultUsdPayoutAccount(defaultUsdPayoutAccount);
            return this;
        }

        public CreditorUpdateRequest withName(String name) {
            this.name = name;
            return this;
        }

        public CreditorUpdateRequest withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public CreditorUpdateRequest withRegion(String region) {
            this.region = region;
            return this;
        }

        private CreditorUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CreditorUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "creditors/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "creditors";
        }

        @Override
        protected Class<Creditor> getResponseClass() {
            return Creditor.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String defaultAudPayoutAccount;
            private String defaultCadPayoutAccount;
            private String defaultDkkPayoutAccount;
            private String defaultEurPayoutAccount;
            private String defaultGbpPayoutAccount;
            private String defaultNzdPayoutAccount;
            private String defaultSekPayoutAccount;
            private String defaultUsdPayoutAccount;

            public Links withDefaultAudPayoutAccount(String defaultAudPayoutAccount) {
                this.defaultAudPayoutAccount = defaultAudPayoutAccount;
                return this;
            }

            public Links withDefaultCadPayoutAccount(String defaultCadPayoutAccount) {
                this.defaultCadPayoutAccount = defaultCadPayoutAccount;
                return this;
            }

            public Links withDefaultDkkPayoutAccount(String defaultDkkPayoutAccount) {
                this.defaultDkkPayoutAccount = defaultDkkPayoutAccount;
                return this;
            }

            public Links withDefaultEurPayoutAccount(String defaultEurPayoutAccount) {
                this.defaultEurPayoutAccount = defaultEurPayoutAccount;
                return this;
            }

            public Links withDefaultGbpPayoutAccount(String defaultGbpPayoutAccount) {
                this.defaultGbpPayoutAccount = defaultGbpPayoutAccount;
                return this;
            }

            public Links withDefaultNzdPayoutAccount(String defaultNzdPayoutAccount) {
                this.defaultNzdPayoutAccount = defaultNzdPayoutAccount;
                return this;
            }

            public Links withDefaultSekPayoutAccount(String defaultSekPayoutAccount) {
                this.defaultSekPayoutAccount = defaultSekPayoutAccount;
                return this;
            }

            public Links withDefaultUsdPayoutAccount(String defaultUsdPayoutAccount) {
                this.defaultUsdPayoutAccount = defaultUsdPayoutAccount;
                return this;
            }
        }
    }

    public static final class CreditorGetRequest
    extends GetRequest<Creditor> {
        @PathParam
        private final String identity;

        private CreditorGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CreditorGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "creditors/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "creditors";
        }

        @Override
        protected Class<Creditor> getResponseClass() {
            return Creditor.class;
        }
    }

    public static final class CreditorListRequest<S>
    extends ListRequest<S, Creditor> {
        private CreatedAt createdAt;

        public CreditorListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public CreditorListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public CreditorListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CreditorListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public CreditorListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public CreditorListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public CreditorListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public CreditorListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        private CreditorListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Creditor> executor) {
            super(httpClient, executor);
        }

        public CreditorListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "creditors";
        }

        @Override
        protected String getEnvelope() {
            return "creditors";
        }

        @Override
        protected TypeToken<List<Creditor>> getTypeToken() {
            return new TypeToken<List<Creditor>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }
    }

    public static final class CreditorCreateRequest
    extends IdempotentPostRequest<Creditor> {
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String city;
        private String countryCode;
        private Map<String, String> links;
        private String name;
        private String postalCode;
        private String region;

        public CreditorCreateRequest withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public CreditorCreateRequest withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public CreditorCreateRequest withAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public CreditorCreateRequest withCity(String city) {
            this.city = city;
            return this;
        }

        public CreditorCreateRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public CreditorCreateRequest withLinks(Map<String, String> links) {
            this.links = links;
            return this;
        }

        public CreditorCreateRequest withLinks(String key, String value) {
            if (this.links == null) {
                this.links = new HashMap<String, String>();
            }
            this.links.put(key, value);
            return this;
        }

        public CreditorCreateRequest withName(String name) {
            this.name = name;
            return this;
        }

        public CreditorCreateRequest withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public CreditorCreateRequest withRegion(String region) {
            this.region = region;
            return this;
        }

        public CreditorCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<Creditor> handleConflict(HttpClient httpClient, String id) {
            CreditorGetRequest request = new CreditorGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private CreditorCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public CreditorCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "creditors";
        }

        @Override
        protected String getEnvelope() {
            return "creditors";
        }

        @Override
        protected Class<Creditor> getResponseClass() {
            return Creditor.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }
}

