/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.HttpClient;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.resources.CurrencyExchangeRate;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class CurrencyExchangeRateService {
    private final HttpClient httpClient;

    public CurrencyExchangeRateService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CurrencyExchangeRateListRequest<ListResponse<CurrencyExchangeRate>> list() {
        return new CurrencyExchangeRateListRequest<ListResponse<CurrencyExchangeRate>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public CurrencyExchangeRateListRequest<Iterable<CurrencyExchangeRate>> all() {
        return new CurrencyExchangeRateListRequest<Iterable<CurrencyExchangeRate>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public static final class CurrencyExchangeRateListRequest<S>
    extends ListRequest<S, CurrencyExchangeRate> {
        private CreatedAt createdAt;
        private String source;
        private String target;

        public CurrencyExchangeRateListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withSource(String source) {
            this.source = source;
            return this;
        }

        public CurrencyExchangeRateListRequest<S> withTarget(String target) {
            this.target = target;
            return this;
        }

        private CurrencyExchangeRateListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, CurrencyExchangeRate> executor) {
            super(httpClient, executor);
        }

        public CurrencyExchangeRateListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.source != null) {
                params.put((Object)"source", (Object)this.source);
            }
            if (this.target != null) {
                params.put((Object)"target", (Object)this.target);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "currency_exchange_rates";
        }

        @Override
        protected String getEnvelope() {
            return "currency_exchange_rates";
        }

        @Override
        protected TypeToken<List<CurrencyExchangeRate>> getTypeToken() {
            return new TypeToken<List<CurrencyExchangeRate>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }
    }
}

