/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.CustomerBankAccount;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerBankAccountService {
    private final HttpClient httpClient;

    public CustomerBankAccountService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CustomerBankAccountCreateRequest create() {
        return new CustomerBankAccountCreateRequest(this.httpClient);
    }

    public CustomerBankAccountListRequest<ListResponse<CustomerBankAccount>> list() {
        return new CustomerBankAccountListRequest<ListResponse<CustomerBankAccount>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public CustomerBankAccountListRequest<Iterable<CustomerBankAccount>> all() {
        return new CustomerBankAccountListRequest<Iterable<CustomerBankAccount>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public CustomerBankAccountGetRequest get(String identity) {
        return new CustomerBankAccountGetRequest(this.httpClient, identity);
    }

    public CustomerBankAccountUpdateRequest update(String identity) {
        return new CustomerBankAccountUpdateRequest(this.httpClient, identity);
    }

    public CustomerBankAccountDisableRequest disable(String identity) {
        return new CustomerBankAccountDisableRequest(this.httpClient, identity);
    }

    public static final class CustomerBankAccountDisableRequest
    extends PostRequest<CustomerBankAccount> {
        @PathParam
        private final String identity;

        private CustomerBankAccountDisableRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CustomerBankAccountDisableRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customer_bank_accounts/:identity/actions/disable";
        }

        @Override
        protected String getEnvelope() {
            return "customer_bank_accounts";
        }

        @Override
        protected Class<CustomerBankAccount> getResponseClass() {
            return CustomerBankAccount.class;
        }

        @Override
        protected boolean hasBody() {
            return false;
        }
    }

    public static final class CustomerBankAccountUpdateRequest
    extends PutRequest<CustomerBankAccount> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public CustomerBankAccountUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public CustomerBankAccountUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private CustomerBankAccountUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CustomerBankAccountUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customer_bank_accounts/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "customer_bank_accounts";
        }

        @Override
        protected Class<CustomerBankAccount> getResponseClass() {
            return CustomerBankAccount.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class CustomerBankAccountGetRequest
    extends GetRequest<CustomerBankAccount> {
        @PathParam
        private final String identity;

        private CustomerBankAccountGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CustomerBankAccountGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customer_bank_accounts/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "customer_bank_accounts";
        }

        @Override
        protected Class<CustomerBankAccount> getResponseClass() {
            return CustomerBankAccount.class;
        }
    }

    public static final class CustomerBankAccountListRequest<S>
    extends ListRequest<S, CustomerBankAccount> {
        private CreatedAt createdAt;
        private String customer;
        private Boolean enabled;

        public CustomerBankAccountListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public CustomerBankAccountListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public CustomerBankAccountListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CustomerBankAccountListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public CustomerBankAccountListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public CustomerBankAccountListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public CustomerBankAccountListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public CustomerBankAccountListRequest<S> withCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public CustomerBankAccountListRequest<S> withEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public CustomerBankAccountListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        private CustomerBankAccountListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, CustomerBankAccount> executor) {
            super(httpClient, executor);
        }

        public CustomerBankAccountListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.customer != null) {
                params.put((Object)"customer", (Object)this.customer);
            }
            if (this.enabled != null) {
                params.put((Object)"enabled", (Object)this.enabled);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customer_bank_accounts";
        }

        @Override
        protected String getEnvelope() {
            return "customer_bank_accounts";
        }

        @Override
        protected TypeToken<List<CustomerBankAccount>> getTypeToken() {
            return new TypeToken<List<CustomerBankAccount>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }
    }

    public static final class CustomerBankAccountCreateRequest
    extends IdempotentPostRequest<CustomerBankAccount> {
        private String accountHolderName;
        private String accountNumber;
        private AccountType accountType;
        private String bankCode;
        private String branchCode;
        private String countryCode;
        private String currency;
        private String iban;
        private Links links;
        private Map<String, String> metadata;

        public CustomerBankAccountCreateRequest withAccountHolderName(String accountHolderName) {
            this.accountHolderName = accountHolderName;
            return this;
        }

        public CustomerBankAccountCreateRequest withAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public CustomerBankAccountCreateRequest withAccountType(AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        public CustomerBankAccountCreateRequest withBankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public CustomerBankAccountCreateRequest withBranchCode(String branchCode) {
            this.branchCode = branchCode;
            return this;
        }

        public CustomerBankAccountCreateRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public CustomerBankAccountCreateRequest withCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public CustomerBankAccountCreateRequest withIban(String iban) {
            this.iban = iban;
            return this;
        }

        public CustomerBankAccountCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public CustomerBankAccountCreateRequest withLinksCustomer(String customer) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCustomer(customer);
            return this;
        }

        public CustomerBankAccountCreateRequest withLinksCustomerBankAccountToken(String customerBankAccountToken) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCustomerBankAccountToken(customerBankAccountToken);
            return this;
        }

        public CustomerBankAccountCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public CustomerBankAccountCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public CustomerBankAccountCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<CustomerBankAccount> handleConflict(HttpClient httpClient, String id) {
            CustomerBankAccountGetRequest request = new CustomerBankAccountGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private CustomerBankAccountCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public CustomerBankAccountCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "customer_bank_accounts";
        }

        @Override
        protected String getEnvelope() {
            return "customer_bank_accounts";
        }

        @Override
        protected Class<CustomerBankAccount> getResponseClass() {
            return CustomerBankAccount.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String customer;
            private String customerBankAccountToken;

            public Links withCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public Links withCustomerBankAccountToken(String customerBankAccountToken) {
                this.customerBankAccountToken = customerBankAccountToken;
                return this;
            }
        }

        public static enum AccountType {
            SAVINGS,
            CHECKING,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

