/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.DeleteRequest;
import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.Customer;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerService {
    private final HttpClient httpClient;

    public CustomerService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CustomerCreateRequest create() {
        return new CustomerCreateRequest(this.httpClient);
    }

    public CustomerListRequest<ListResponse<Customer>> list() {
        return new CustomerListRequest<ListResponse<Customer>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public CustomerListRequest<Iterable<Customer>> all() {
        return new CustomerListRequest<Iterable<Customer>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public CustomerGetRequest get(String identity) {
        return new CustomerGetRequest(this.httpClient, identity);
    }

    public CustomerUpdateRequest update(String identity) {
        return new CustomerUpdateRequest(this.httpClient, identity);
    }

    public CustomerRemoveRequest remove(String identity) {
        return new CustomerRemoveRequest(this.httpClient, identity);
    }

    public static final class CustomerRemoveRequest
    extends DeleteRequest<Customer> {
        @PathParam
        private final String identity;

        private CustomerRemoveRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CustomerRemoveRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customers/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "customers";
        }

        @Override
        protected Class<Customer> getResponseClass() {
            return Customer.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class CustomerUpdateRequest
    extends PutRequest<Customer> {
        @PathParam
        private final String identity;
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String city;
        private String companyName;
        private String countryCode;
        private String danishIdentityNumber;
        private String email;
        private String familyName;
        private String givenName;
        private String language;
        private Map<String, String> metadata;
        private String phoneNumber;
        private String postalCode;
        private String region;
        private String swedishIdentityNumber;

        public CustomerUpdateRequest withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public CustomerUpdateRequest withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public CustomerUpdateRequest withAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public CustomerUpdateRequest withCity(String city) {
            this.city = city;
            return this;
        }

        public CustomerUpdateRequest withCompanyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public CustomerUpdateRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public CustomerUpdateRequest withDanishIdentityNumber(String danishIdentityNumber) {
            this.danishIdentityNumber = danishIdentityNumber;
            return this;
        }

        public CustomerUpdateRequest withEmail(String email) {
            this.email = email;
            return this;
        }

        public CustomerUpdateRequest withFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public CustomerUpdateRequest withGivenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public CustomerUpdateRequest withLanguage(String language) {
            this.language = language;
            return this;
        }

        public CustomerUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public CustomerUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public CustomerUpdateRequest withPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public CustomerUpdateRequest withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public CustomerUpdateRequest withRegion(String region) {
            this.region = region;
            return this;
        }

        public CustomerUpdateRequest withSwedishIdentityNumber(String swedishIdentityNumber) {
            this.swedishIdentityNumber = swedishIdentityNumber;
            return this;
        }

        private CustomerUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CustomerUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customers/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "customers";
        }

        @Override
        protected Class<Customer> getResponseClass() {
            return Customer.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class CustomerGetRequest
    extends GetRequest<Customer> {
        @PathParam
        private final String identity;

        private CustomerGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public CustomerGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customers/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "customers";
        }

        @Override
        protected Class<Customer> getResponseClass() {
            return Customer.class;
        }
    }

    public static final class CustomerListRequest<S>
    extends ListRequest<S, Customer> {
        private CreatedAt createdAt;
        private Currency currency;
        private SortDirection sortDirection;
        private SortField sortField;

        public CustomerListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public CustomerListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public CustomerListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CustomerListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public CustomerListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public CustomerListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public CustomerListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public CustomerListRequest<S> withCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public CustomerListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public CustomerListRequest<S> withSortDirection(SortDirection sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public CustomerListRequest<S> withSortField(SortField sortField) {
            this.sortField = sortField;
            return this;
        }

        private CustomerListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Customer> executor) {
            super(httpClient, executor);
        }

        public CustomerListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.currency != null) {
                params.put((Object)"currency", (Object)this.currency);
            }
            if (this.sortDirection != null) {
                params.put((Object)"sort_direction", (Object)this.sortDirection);
            }
            if (this.sortField != null) {
                params.put((Object)"sort_field", (Object)this.sortField);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "customers";
        }

        @Override
        protected String getEnvelope() {
            return "customers";
        }

        @Override
        protected TypeToken<List<Customer>> getTypeToken() {
            return new TypeToken<List<Customer>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static enum SortField {
            NAME,
            COMPANY_NAME,
            CREATED_AT,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum SortDirection {
            ASC,
            DESC,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum Currency {
            AUD,
            CAD,
            DKK,
            EUR,
            GBP,
            NZD,
            SEK,
            USD,
            UNKNOWN;


            public String toString() {
                return this.name();
            }
        }
    }

    public static final class CustomerCreateRequest
    extends IdempotentPostRequest<Customer> {
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String city;
        private String companyName;
        private String countryCode;
        private String danishIdentityNumber;
        private String email;
        private String familyName;
        private String givenName;
        private String language;
        private Map<String, String> metadata;
        private String phoneNumber;
        private String postalCode;
        private String region;
        private String swedishIdentityNumber;

        public CustomerCreateRequest withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public CustomerCreateRequest withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public CustomerCreateRequest withAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public CustomerCreateRequest withCity(String city) {
            this.city = city;
            return this;
        }

        public CustomerCreateRequest withCompanyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public CustomerCreateRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public CustomerCreateRequest withDanishIdentityNumber(String danishIdentityNumber) {
            this.danishIdentityNumber = danishIdentityNumber;
            return this;
        }

        public CustomerCreateRequest withEmail(String email) {
            this.email = email;
            return this;
        }

        public CustomerCreateRequest withFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public CustomerCreateRequest withGivenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public CustomerCreateRequest withLanguage(String language) {
            this.language = language;
            return this;
        }

        public CustomerCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public CustomerCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public CustomerCreateRequest withPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public CustomerCreateRequest withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public CustomerCreateRequest withRegion(String region) {
            this.region = region;
            return this;
        }

        public CustomerCreateRequest withSwedishIdentityNumber(String swedishIdentityNumber) {
            this.swedishIdentityNumber = swedishIdentityNumber;
            return this;
        }

        public CustomerCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<Customer> handleConflict(HttpClient httpClient, String id) {
            CustomerGetRequest request = new CustomerGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private CustomerCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public CustomerCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "customers";
        }

        @Override
        protected String getEnvelope() {
            return "customers";
        }

        @Override
        protected Class<Customer> getResponseClass() {
            return Customer.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }
}

