/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.resources.Event;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class EventService {
    private final HttpClient httpClient;

    public EventService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public EventListRequest<ListResponse<Event>> list() {
        return new EventListRequest<ListResponse<Event>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public EventListRequest<Iterable<Event>> all() {
        return new EventListRequest<Iterable<Event>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public EventGetRequest get(String identity) {
        return new EventGetRequest(this.httpClient, identity);
    }

    public static final class EventGetRequest
    extends GetRequest<Event> {
        @PathParam
        private final String identity;

        private EventGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public EventGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "events/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "events";
        }

        @Override
        protected Class<Event> getResponseClass() {
            return Event.class;
        }
    }

    public static final class EventListRequest<S>
    extends ListRequest<S, Event> {
        private String action;
        private String billingRequest;
        private CreatedAt createdAt;
        private Include include;
        private String instalmentSchedule;
        private String mandate;
        private String parentEvent;
        private String payerAuthorisation;
        private String payment;
        private String payout;
        private String refund;
        private ResourceType resourceType;
        private String subscription;

        public EventListRequest<S> withAction(String action) {
            this.action = action;
            return this;
        }

        public EventListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public EventListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public EventListRequest<S> withBillingRequest(String billingRequest) {
            this.billingRequest = billingRequest;
            return this;
        }

        public EventListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public EventListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public EventListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public EventListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public EventListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public EventListRequest<S> withInclude(Include include) {
            this.include = include;
            return this;
        }

        public EventListRequest<S> withInstalmentSchedule(String instalmentSchedule) {
            this.instalmentSchedule = instalmentSchedule;
            return this;
        }

        public EventListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public EventListRequest<S> withMandate(String mandate) {
            this.mandate = mandate;
            return this;
        }

        public EventListRequest<S> withParentEvent(String parentEvent) {
            this.parentEvent = parentEvent;
            return this;
        }

        public EventListRequest<S> withPayerAuthorisation(String payerAuthorisation) {
            this.payerAuthorisation = payerAuthorisation;
            return this;
        }

        public EventListRequest<S> withPayment(String payment) {
            this.payment = payment;
            return this;
        }

        public EventListRequest<S> withPayout(String payout) {
            this.payout = payout;
            return this;
        }

        public EventListRequest<S> withRefund(String refund) {
            this.refund = refund;
            return this;
        }

        public EventListRequest<S> withResourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public EventListRequest<S> withSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private EventListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Event> executor) {
            super(httpClient, executor);
        }

        public EventListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.action != null) {
                params.put((Object)"action", (Object)this.action);
            }
            if (this.billingRequest != null) {
                params.put((Object)"billing_request", (Object)this.billingRequest);
            }
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.include != null) {
                params.put((Object)"include", (Object)this.include);
            }
            if (this.instalmentSchedule != null) {
                params.put((Object)"instalment_schedule", (Object)this.instalmentSchedule);
            }
            if (this.mandate != null) {
                params.put((Object)"mandate", (Object)this.mandate);
            }
            if (this.parentEvent != null) {
                params.put((Object)"parent_event", (Object)this.parentEvent);
            }
            if (this.payerAuthorisation != null) {
                params.put((Object)"payer_authorisation", (Object)this.payerAuthorisation);
            }
            if (this.payment != null) {
                params.put((Object)"payment", (Object)this.payment);
            }
            if (this.payout != null) {
                params.put((Object)"payout", (Object)this.payout);
            }
            if (this.refund != null) {
                params.put((Object)"refund", (Object)this.refund);
            }
            if (this.resourceType != null) {
                params.put((Object)"resource_type", (Object)this.resourceType);
            }
            if (this.subscription != null) {
                params.put((Object)"subscription", (Object)this.subscription);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "events";
        }

        @Override
        protected String getEnvelope() {
            return "events";
        }

        @Override
        protected TypeToken<List<Event>> getTypeToken() {
            return new TypeToken<List<Event>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static enum ResourceType {
            BILLING_REQUESTS,
            CREDITORS,
            INSTALMENT_SCHEDULES,
            MANDATES,
            ORGANISATIONS,
            PAYER_AUTHORISATIONS,
            PAYMENTS,
            PAYOUTS,
            REFUNDS,
            SUBSCRIPTIONS,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum Include {
            PAYMENT,
            MANDATE,
            PAYOUT,
            REFUND,
            SUBSCRIPTION,
            INSTALMENT_SCHEDULE,
            CREDITOR,
            PAYER_AUTHORISATION,
            BILLING_REQUEST,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

