/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.InstalmentSchedule;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InstalmentScheduleService {
    private final HttpClient httpClient;

    public InstalmentScheduleService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public InstalmentScheduleCreateWithDatesRequest createWithDates() {
        return new InstalmentScheduleCreateWithDatesRequest(this.httpClient);
    }

    public InstalmentScheduleCreateWithScheduleRequest createWithSchedule() {
        return new InstalmentScheduleCreateWithScheduleRequest(this.httpClient);
    }

    public InstalmentScheduleListRequest<ListResponse<InstalmentSchedule>> list() {
        return new InstalmentScheduleListRequest<ListResponse<InstalmentSchedule>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public InstalmentScheduleListRequest<Iterable<InstalmentSchedule>> all() {
        return new InstalmentScheduleListRequest<Iterable<InstalmentSchedule>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public InstalmentScheduleGetRequest get(String identity) {
        return new InstalmentScheduleGetRequest(this.httpClient, identity);
    }

    public InstalmentScheduleUpdateRequest update(String identity) {
        return new InstalmentScheduleUpdateRequest(this.httpClient, identity);
    }

    public InstalmentScheduleCancelRequest cancel(String identity) {
        return new InstalmentScheduleCancelRequest(this.httpClient, identity);
    }

    public static final class InstalmentScheduleCancelRequest
    extends PostRequest<InstalmentSchedule> {
        @PathParam
        private final String identity;

        private InstalmentScheduleCancelRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public InstalmentScheduleCancelRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "instalment_schedules/:identity/actions/cancel";
        }

        @Override
        protected String getEnvelope() {
            return "instalment_schedules";
        }

        @Override
        protected Class<InstalmentSchedule> getResponseClass() {
            return InstalmentSchedule.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class InstalmentScheduleUpdateRequest
    extends PutRequest<InstalmentSchedule> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public InstalmentScheduleUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public InstalmentScheduleUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private InstalmentScheduleUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public InstalmentScheduleUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "instalment_schedules/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "instalment_schedules";
        }

        @Override
        protected Class<InstalmentSchedule> getResponseClass() {
            return InstalmentSchedule.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class InstalmentScheduleGetRequest
    extends GetRequest<InstalmentSchedule> {
        @PathParam
        private final String identity;

        private InstalmentScheduleGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public InstalmentScheduleGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "instalment_schedules/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "instalment_schedules";
        }

        @Override
        protected Class<InstalmentSchedule> getResponseClass() {
            return InstalmentSchedule.class;
        }
    }

    public static final class InstalmentScheduleListRequest<S>
    extends ListRequest<S, InstalmentSchedule> {
        private CreatedAt createdAt;
        private String customer;
        private String mandate;
        private List<Status> status;

        public InstalmentScheduleListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public InstalmentScheduleListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public InstalmentScheduleListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public InstalmentScheduleListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public InstalmentScheduleListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public InstalmentScheduleListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public InstalmentScheduleListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public InstalmentScheduleListRequest<S> withCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public InstalmentScheduleListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public InstalmentScheduleListRequest<S> withMandate(String mandate) {
            this.mandate = mandate;
            return this;
        }

        public InstalmentScheduleListRequest<S> withStatus(List<Status> status) {
            this.status = status;
            return this;
        }

        public InstalmentScheduleListRequest<S> withStatus(Status status) {
            if (this.status == null) {
                this.status = new ArrayList<Status>();
            }
            this.status.add(status);
            return this;
        }

        private InstalmentScheduleListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, InstalmentSchedule> executor) {
            super(httpClient, executor);
        }

        public InstalmentScheduleListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.customer != null) {
                params.put((Object)"customer", (Object)this.customer);
            }
            if (this.mandate != null) {
                params.put((Object)"mandate", (Object)this.mandate);
            }
            if (this.status != null) {
                params.put((Object)"status", (Object)Joiner.on((String)",").join(this.status));
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "instalment_schedules";
        }

        @Override
        protected String getEnvelope() {
            return "instalment_schedules";
        }

        @Override
        protected TypeToken<List<InstalmentSchedule>> getTypeToken() {
            return new TypeToken<List<InstalmentSchedule>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static enum Status {
            PENDING,
            ACTIVE,
            CREATION_FAILED,
            COMPLETED,
            CANCELLED,
            ERRORED,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static final class InstalmentScheduleCreateWithScheduleRequest
    extends IdempotentPostRequest<InstalmentSchedule> {
        private Integer appFee;
        private Currency currency;
        private Instalments instalments;
        private Links links;
        private Map<String, String> metadata;
        private String name;
        private String paymentReference;
        private Boolean retryIfPossible;
        private Integer totalAmount;

        public InstalmentScheduleCreateWithScheduleRequest withAppFee(Integer appFee) {
            this.appFee = appFee;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withInstalments(Instalments instalments) {
            this.instalments = instalments;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withInstalmentsAmounts(List<Integer> amounts) {
            if (this.instalments == null) {
                this.instalments = new Instalments();
            }
            this.instalments.withAmounts(amounts);
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withInstalmentsInterval(Integer interval) {
            if (this.instalments == null) {
                this.instalments = new Instalments();
            }
            this.instalments.withInterval(interval);
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withInstalmentsIntervalUnit(Instalments.IntervalUnit intervalUnit) {
            if (this.instalments == null) {
                this.instalments = new Instalments();
            }
            this.instalments.withIntervalUnit(intervalUnit);
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withInstalmentsStartDate(String startDate) {
            if (this.instalments == null) {
                this.instalments = new Instalments();
            }
            this.instalments.withStartDate(startDate);
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withLinksMandate(String mandate) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withMandate(mandate);
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withName(String name) {
            this.name = name;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withPaymentReference(String paymentReference) {
            this.paymentReference = paymentReference;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withRetryIfPossible(Boolean retryIfPossible) {
            this.retryIfPossible = retryIfPossible;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withTotalAmount(Integer totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public InstalmentScheduleCreateWithScheduleRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<InstalmentSchedule> handleConflict(HttpClient httpClient, String id) {
            InstalmentScheduleGetRequest request = new InstalmentScheduleGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private InstalmentScheduleCreateWithScheduleRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public InstalmentScheduleCreateWithScheduleRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "instalment_schedules";
        }

        @Override
        protected String getEnvelope() {
            return "instalment_schedules";
        }

        @Override
        protected Class<InstalmentSchedule> getResponseClass() {
            return InstalmentSchedule.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String mandate;

            public Links withMandate(String mandate) {
                this.mandate = mandate;
                return this;
            }
        }

        public static class Instalments {
            private List<Integer> amounts;
            private Integer interval;
            private IntervalUnit intervalUnit;
            private String startDate;

            public Instalments withAmounts(List<Integer> amounts) {
                this.amounts = amounts;
                return this;
            }

            public Instalments withInterval(Integer interval) {
                this.interval = interval;
                return this;
            }

            public Instalments withIntervalUnit(IntervalUnit intervalUnit) {
                this.intervalUnit = intervalUnit;
                return this;
            }

            public Instalments withStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public static enum IntervalUnit {
                WEEKLY,
                MONTHLY,
                YEARLY,
                UNKNOWN;


                public String toString() {
                    return this.name().toLowerCase();
                }
            }
        }

        public static enum Currency {
            AUD,
            CAD,
            DKK,
            EUR,
            GBP,
            NZD,
            SEK,
            USD,
            UNKNOWN;


            public String toString() {
                return this.name();
            }
        }
    }

    public static final class InstalmentScheduleCreateWithDatesRequest
    extends IdempotentPostRequest<InstalmentSchedule> {
        private Integer appFee;
        private Currency currency;
        private List<Instalments> instalments;
        private Links links;
        private Map<String, String> metadata;
        private String name;
        private String paymentReference;
        private Boolean retryIfPossible;
        private Integer totalAmount;

        public InstalmentScheduleCreateWithDatesRequest withAppFee(Integer appFee) {
            this.appFee = appFee;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withInstalments(List<Instalments> instalments) {
            this.instalments = instalments;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withInstalments(Instalments instalments) {
            if (this.instalments == null) {
                this.instalments = new ArrayList<Instalments>();
            }
            this.instalments.add(instalments);
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withLinksMandate(String mandate) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withMandate(mandate);
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withName(String name) {
            this.name = name;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withPaymentReference(String paymentReference) {
            this.paymentReference = paymentReference;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withRetryIfPossible(Boolean retryIfPossible) {
            this.retryIfPossible = retryIfPossible;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withTotalAmount(Integer totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public InstalmentScheduleCreateWithDatesRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<InstalmentSchedule> handleConflict(HttpClient httpClient, String id) {
            InstalmentScheduleGetRequest request = new InstalmentScheduleGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private InstalmentScheduleCreateWithDatesRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public InstalmentScheduleCreateWithDatesRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "instalment_schedules";
        }

        @Override
        protected String getEnvelope() {
            return "instalment_schedules";
        }

        @Override
        protected Class<InstalmentSchedule> getResponseClass() {
            return InstalmentSchedule.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String mandate;

            public Links withMandate(String mandate) {
                this.mandate = mandate;
                return this;
            }
        }

        public static class Instalments {
            private Integer amount;
            private String chargeDate;
            private String description;

            public Instalments withAmount(Integer amount) {
                this.amount = amount;
                return this;
            }

            public Instalments withChargeDate(String chargeDate) {
                this.chargeDate = chargeDate;
                return this;
            }

            public Instalments withDescription(String description) {
                this.description = description;
                return this;
            }
        }

        public static enum Currency {
            AUD,
            CAD,
            DKK,
            EUR,
            GBP,
            NZD,
            SEK,
            USD,
            UNKNOWN;


            public String toString() {
                return this.name();
            }
        }
    }
}

