/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.HttpClient;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.MandateImportEntry;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class MandateImportEntryService {
    private final HttpClient httpClient;

    public MandateImportEntryService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public MandateImportEntryCreateRequest create() {
        return new MandateImportEntryCreateRequest(this.httpClient);
    }

    public MandateImportEntryListRequest<ListResponse<MandateImportEntry>> list() {
        return new MandateImportEntryListRequest<ListResponse<MandateImportEntry>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public MandateImportEntryListRequest<Iterable<MandateImportEntry>> all() {
        return new MandateImportEntryListRequest<Iterable<MandateImportEntry>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public static final class MandateImportEntryListRequest<S>
    extends ListRequest<S, MandateImportEntry> {
        private String mandateImport;

        public MandateImportEntryListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public MandateImportEntryListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public MandateImportEntryListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public MandateImportEntryListRequest<S> withMandateImport(String mandateImport) {
            this.mandateImport = mandateImport;
            return this;
        }

        private MandateImportEntryListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, MandateImportEntry> executor) {
            super(httpClient, executor);
        }

        public MandateImportEntryListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.mandateImport != null) {
                params.put((Object)"mandate_import", (Object)this.mandateImport);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandate_import_entries";
        }

        @Override
        protected String getEnvelope() {
            return "mandate_import_entries";
        }

        @Override
        protected TypeToken<List<MandateImportEntry>> getTypeToken() {
            return new TypeToken<List<MandateImportEntry>>(){};
        }
    }

    public static final class MandateImportEntryCreateRequest
    extends PostRequest<MandateImportEntry> {
        private Amendment amendment;
        private BankAccount bankAccount;
        private Customer customer;
        private Links links;
        private String recordIdentifier;

        public MandateImportEntryCreateRequest withAmendment(Amendment amendment) {
            this.amendment = amendment;
            return this;
        }

        public MandateImportEntryCreateRequest withAmendmentOriginalCreditorId(String originalCreditorId) {
            if (this.amendment == null) {
                this.amendment = new Amendment();
            }
            this.amendment.withOriginalCreditorId(originalCreditorId);
            return this;
        }

        public MandateImportEntryCreateRequest withAmendmentOriginalCreditorName(String originalCreditorName) {
            if (this.amendment == null) {
                this.amendment = new Amendment();
            }
            this.amendment.withOriginalCreditorName(originalCreditorName);
            return this;
        }

        public MandateImportEntryCreateRequest withAmendmentOriginalMandateReference(String originalMandateReference) {
            if (this.amendment == null) {
                this.amendment = new Amendment();
            }
            this.amendment.withOriginalMandateReference(originalMandateReference);
            return this;
        }

        public MandateImportEntryCreateRequest withBankAccount(BankAccount bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public MandateImportEntryCreateRequest withBankAccountAccountHolderName(String accountHolderName) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountHolderName(accountHolderName);
            return this;
        }

        public MandateImportEntryCreateRequest withBankAccountAccountNumber(String accountNumber) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountNumber(accountNumber);
            return this;
        }

        public MandateImportEntryCreateRequest withBankAccountBankCode(String bankCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withBankCode(bankCode);
            return this;
        }

        public MandateImportEntryCreateRequest withBankAccountBranchCode(String branchCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withBranchCode(branchCode);
            return this;
        }

        public MandateImportEntryCreateRequest withBankAccountCountryCode(String countryCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withCountryCode(countryCode);
            return this;
        }

        public MandateImportEntryCreateRequest withBankAccountIban(String iban) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withIban(iban);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerAddressLine1(String addressLine1) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine1(addressLine1);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerAddressLine2(String addressLine2) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine2(addressLine2);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerAddressLine3(String addressLine3) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine3(addressLine3);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerCity(String city) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCity(city);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerCompanyName(String companyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCompanyName(companyName);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerCountryCode(String countryCode) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCountryCode(countryCode);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerDanishIdentityNumber(String danishIdentityNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withDanishIdentityNumber(danishIdentityNumber);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerEmail(String email) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withEmail(email);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerFamilyName(String familyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withFamilyName(familyName);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerGivenName(String givenName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withGivenName(givenName);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerLanguage(String language) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withLanguage(language);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerPhoneNumber(String phoneNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withPhoneNumber(phoneNumber);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerPostalCode(String postalCode) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withPostalCode(postalCode);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerRegion(String region) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withRegion(region);
            return this;
        }

        public MandateImportEntryCreateRequest withCustomerSwedishIdentityNumber(String swedishIdentityNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withSwedishIdentityNumber(swedishIdentityNumber);
            return this;
        }

        public MandateImportEntryCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public MandateImportEntryCreateRequest withLinksMandateImport(String mandateImport) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withMandateImport(mandateImport);
            return this;
        }

        public MandateImportEntryCreateRequest withRecordIdentifier(String recordIdentifier) {
            this.recordIdentifier = recordIdentifier;
            return this;
        }

        private MandateImportEntryCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public MandateImportEntryCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "mandate_import_entries";
        }

        @Override
        protected String getEnvelope() {
            return "mandate_import_entries";
        }

        @Override
        protected Class<MandateImportEntry> getResponseClass() {
            return MandateImportEntry.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String mandateImport;

            public Links withMandateImport(String mandateImport) {
                this.mandateImport = mandateImport;
                return this;
            }
        }

        public static class Customer {
            private String addressLine1;
            private String addressLine2;
            private String addressLine3;
            private String city;
            private String companyName;
            private String countryCode;
            private String danishIdentityNumber;
            private String email;
            private String familyName;
            private String givenName;
            private String language;
            private String phoneNumber;
            private String postalCode;
            private String region;
            private String swedishIdentityNumber;

            public Customer withAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            public Customer withAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            public Customer withAddressLine3(String addressLine3) {
                this.addressLine3 = addressLine3;
                return this;
            }

            public Customer withCity(String city) {
                this.city = city;
                return this;
            }

            public Customer withCompanyName(String companyName) {
                this.companyName = companyName;
                return this;
            }

            public Customer withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public Customer withDanishIdentityNumber(String danishIdentityNumber) {
                this.danishIdentityNumber = danishIdentityNumber;
                return this;
            }

            public Customer withEmail(String email) {
                this.email = email;
                return this;
            }

            public Customer withFamilyName(String familyName) {
                this.familyName = familyName;
                return this;
            }

            public Customer withGivenName(String givenName) {
                this.givenName = givenName;
                return this;
            }

            public Customer withLanguage(String language) {
                this.language = language;
                return this;
            }

            public Customer withPhoneNumber(String phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            public Customer withPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public Customer withRegion(String region) {
                this.region = region;
                return this;
            }

            public Customer withSwedishIdentityNumber(String swedishIdentityNumber) {
                this.swedishIdentityNumber = swedishIdentityNumber;
                return this;
            }
        }

        public static class BankAccount {
            private String accountHolderName;
            private String accountNumber;
            private String bankCode;
            private String branchCode;
            private String countryCode;
            private String iban;

            public BankAccount withAccountHolderName(String accountHolderName) {
                this.accountHolderName = accountHolderName;
                return this;
            }

            public BankAccount withAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
                return this;
            }

            public BankAccount withBankCode(String bankCode) {
                this.bankCode = bankCode;
                return this;
            }

            public BankAccount withBranchCode(String branchCode) {
                this.branchCode = branchCode;
                return this;
            }

            public BankAccount withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public BankAccount withIban(String iban) {
                this.iban = iban;
                return this;
            }
        }

        public static class Amendment {
            private String originalCreditorId;
            private String originalCreditorName;
            private String originalMandateReference;

            public Amendment withOriginalCreditorId(String originalCreditorId) {
                this.originalCreditorId = originalCreditorId;
                return this;
            }

            public Amendment withOriginalCreditorName(String originalCreditorName) {
                this.originalCreditorName = originalCreditorName;
                return this;
            }

            public Amendment withOriginalMandateReference(String originalMandateReference) {
                this.originalMandateReference = originalMandateReference;
                return this;
            }
        }
    }
}

