/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.MandateImport;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class MandateImportService {
    private final HttpClient httpClient;

    public MandateImportService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public MandateImportCreateRequest create() {
        return new MandateImportCreateRequest(this.httpClient);
    }

    public MandateImportGetRequest get(String identity) {
        return new MandateImportGetRequest(this.httpClient, identity);
    }

    public MandateImportSubmitRequest submit(String identity) {
        return new MandateImportSubmitRequest(this.httpClient, identity);
    }

    public MandateImportCancelRequest cancel(String identity) {
        return new MandateImportCancelRequest(this.httpClient, identity);
    }

    public static final class MandateImportCancelRequest
    extends PostRequest<MandateImport> {
        @PathParam
        private final String identity;

        private MandateImportCancelRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public MandateImportCancelRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandate_imports/:identity/actions/cancel";
        }

        @Override
        protected String getEnvelope() {
            return "mandate_imports";
        }

        @Override
        protected Class<MandateImport> getResponseClass() {
            return MandateImport.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class MandateImportSubmitRequest
    extends PostRequest<MandateImport> {
        @PathParam
        private final String identity;

        private MandateImportSubmitRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public MandateImportSubmitRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandate_imports/:identity/actions/submit";
        }

        @Override
        protected String getEnvelope() {
            return "mandate_imports";
        }

        @Override
        protected Class<MandateImport> getResponseClass() {
            return MandateImport.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class MandateImportGetRequest
    extends GetRequest<MandateImport> {
        @PathParam
        private final String identity;

        private MandateImportGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public MandateImportGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandate_imports/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "mandate_imports";
        }

        @Override
        protected Class<MandateImport> getResponseClass() {
            return MandateImport.class;
        }
    }

    public static final class MandateImportCreateRequest
    extends IdempotentPostRequest<MandateImport> {
        private Scheme scheme;

        public MandateImportCreateRequest withScheme(Scheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public MandateImportCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<MandateImport> handleConflict(HttpClient httpClient, String id) {
            MandateImportGetRequest request = new MandateImportGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private MandateImportCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public MandateImportCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "mandate_imports";
        }

        @Override
        protected String getEnvelope() {
            return "mandate_imports";
        }

        @Override
        protected Class<MandateImport> getResponseClass() {
            return MandateImport.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static enum Scheme {
            ACH,
            AUTOGIRO,
            BACS,
            BECS,
            BECS_NZ,
            BETALINGSSERVICE,
            PAD,
            SEPA_CORE,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

