/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.HttpClient;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.MandatePdf;

public class MandatePdfService {
    private final HttpClient httpClient;

    public MandatePdfService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public MandatePdfCreateRequest create() {
        return new MandatePdfCreateRequest(this.httpClient);
    }

    public static final class MandatePdfCreateRequest
    extends PostRequest<MandatePdf> {
        private String accountHolderName;
        private String accountNumber;
        private AccountType accountType;
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String bankCode;
        private String bic;
        private String branchCode;
        private String city;
        private String countryCode;
        private String danishIdentityNumber;
        private String iban;
        private Links links;
        private String mandateReference;
        private String payerIpAddress;
        private String phoneNumber;
        private String postalCode;
        private String region;
        private String scheme;
        private String signatureDate;
        private Integer subscriptionAmount;
        private String subscriptionFrequency;
        private String swedishIdentityNumber;

        public MandatePdfCreateRequest withAccountHolderName(String accountHolderName) {
            this.accountHolderName = accountHolderName;
            return this;
        }

        public MandatePdfCreateRequest withAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public MandatePdfCreateRequest withAccountType(AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        public MandatePdfCreateRequest withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public MandatePdfCreateRequest withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public MandatePdfCreateRequest withAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public MandatePdfCreateRequest withBankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        public MandatePdfCreateRequest withBic(String bic) {
            this.bic = bic;
            return this;
        }

        public MandatePdfCreateRequest withBranchCode(String branchCode) {
            this.branchCode = branchCode;
            return this;
        }

        public MandatePdfCreateRequest withCity(String city) {
            this.city = city;
            return this;
        }

        public MandatePdfCreateRequest withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public MandatePdfCreateRequest withDanishIdentityNumber(String danishIdentityNumber) {
            this.danishIdentityNumber = danishIdentityNumber;
            return this;
        }

        public MandatePdfCreateRequest withIban(String iban) {
            this.iban = iban;
            return this;
        }

        public MandatePdfCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public MandatePdfCreateRequest withLinksMandate(String mandate) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withMandate(mandate);
            return this;
        }

        public MandatePdfCreateRequest withMandateReference(String mandateReference) {
            this.mandateReference = mandateReference;
            return this;
        }

        public MandatePdfCreateRequest withPayerIpAddress(String payerIpAddress) {
            this.payerIpAddress = payerIpAddress;
            return this;
        }

        public MandatePdfCreateRequest withPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public MandatePdfCreateRequest withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public MandatePdfCreateRequest withRegion(String region) {
            this.region = region;
            return this;
        }

        public MandatePdfCreateRequest withScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public MandatePdfCreateRequest withSignatureDate(String signatureDate) {
            this.signatureDate = signatureDate;
            return this;
        }

        public MandatePdfCreateRequest withSubscriptionAmount(Integer subscriptionAmount) {
            this.subscriptionAmount = subscriptionAmount;
            return this;
        }

        public MandatePdfCreateRequest withSubscriptionFrequency(String subscriptionFrequency) {
            this.subscriptionFrequency = subscriptionFrequency;
            return this;
        }

        public MandatePdfCreateRequest withSwedishIdentityNumber(String swedishIdentityNumber) {
            this.swedishIdentityNumber = swedishIdentityNumber;
            return this;
        }

        private MandatePdfCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public MandatePdfCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "mandate_pdfs";
        }

        @Override
        protected String getEnvelope() {
            return "mandate_pdfs";
        }

        @Override
        protected Class<MandatePdf> getResponseClass() {
            return MandatePdf.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String mandate;

            public Links withMandate(String mandate) {
                this.mandate = mandate;
                return this;
            }
        }

        public static enum AccountType {
            SAVINGS,
            CHECKING,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

