/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.Mandate;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MandateService {
    private final HttpClient httpClient;

    public MandateService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public MandateCreateRequest create() {
        return new MandateCreateRequest(this.httpClient);
    }

    public MandateListRequest<ListResponse<Mandate>> list() {
        return new MandateListRequest<ListResponse<Mandate>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public MandateListRequest<Iterable<Mandate>> all() {
        return new MandateListRequest<Iterable<Mandate>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public MandateGetRequest get(String identity) {
        return new MandateGetRequest(this.httpClient, identity);
    }

    public MandateUpdateRequest update(String identity) {
        return new MandateUpdateRequest(this.httpClient, identity);
    }

    public MandateCancelRequest cancel(String identity) {
        return new MandateCancelRequest(this.httpClient, identity);
    }

    public MandateReinstateRequest reinstate(String identity) {
        return new MandateReinstateRequest(this.httpClient, identity);
    }

    public static final class MandateReinstateRequest
    extends PostRequest<Mandate> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public MandateReinstateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public MandateReinstateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private MandateReinstateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public MandateReinstateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandates/:identity/actions/reinstate";
        }

        @Override
        protected String getEnvelope() {
            return "mandates";
        }

        @Override
        protected Class<Mandate> getResponseClass() {
            return Mandate.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class MandateCancelRequest
    extends PostRequest<Mandate> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public MandateCancelRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public MandateCancelRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private MandateCancelRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public MandateCancelRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandates/:identity/actions/cancel";
        }

        @Override
        protected String getEnvelope() {
            return "mandates";
        }

        @Override
        protected Class<Mandate> getResponseClass() {
            return Mandate.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class MandateUpdateRequest
    extends PutRequest<Mandate> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public MandateUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public MandateUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private MandateUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public MandateUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandates/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "mandates";
        }

        @Override
        protected Class<Mandate> getResponseClass() {
            return Mandate.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class MandateGetRequest
    extends GetRequest<Mandate> {
        @PathParam
        private final String identity;

        private MandateGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public MandateGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandates/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "mandates";
        }

        @Override
        protected Class<Mandate> getResponseClass() {
            return Mandate.class;
        }
    }

    public static final class MandateListRequest<S>
    extends ListRequest<S, Mandate> {
        private CreatedAt createdAt;
        private String creditor;
        private String customer;
        private String customerBankAccount;
        private String reference;
        private List<String> scheme;
        private List<Status> status;

        public MandateListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public MandateListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public MandateListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public MandateListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public MandateListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public MandateListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public MandateListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public MandateListRequest<S> withCreditor(String creditor) {
            this.creditor = creditor;
            return this;
        }

        public MandateListRequest<S> withCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public MandateListRequest<S> withCustomerBankAccount(String customerBankAccount) {
            this.customerBankAccount = customerBankAccount;
            return this;
        }

        public MandateListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public MandateListRequest<S> withReference(String reference) {
            this.reference = reference;
            return this;
        }

        public MandateListRequest<S> withScheme(List<String> scheme) {
            this.scheme = scheme;
            return this;
        }

        public MandateListRequest<S> withScheme(String scheme) {
            if (this.scheme == null) {
                this.scheme = new ArrayList<String>();
            }
            this.scheme.add(scheme);
            return this;
        }

        public MandateListRequest<S> withStatus(List<Status> status) {
            this.status = status;
            return this;
        }

        public MandateListRequest<S> withStatus(Status status) {
            if (this.status == null) {
                this.status = new ArrayList<Status>();
            }
            this.status.add(status);
            return this;
        }

        private MandateListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Mandate> executor) {
            super(httpClient, executor);
        }

        public MandateListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.creditor != null) {
                params.put((Object)"creditor", (Object)this.creditor);
            }
            if (this.customer != null) {
                params.put((Object)"customer", (Object)this.customer);
            }
            if (this.customerBankAccount != null) {
                params.put((Object)"customer_bank_account", (Object)this.customerBankAccount);
            }
            if (this.reference != null) {
                params.put((Object)"reference", (Object)this.reference);
            }
            if (this.scheme != null) {
                params.put((Object)"scheme", (Object)Joiner.on((String)",").join(this.scheme));
            }
            if (this.status != null) {
                params.put((Object)"status", (Object)Joiner.on((String)",").join(this.status));
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "mandates";
        }

        @Override
        protected String getEnvelope() {
            return "mandates";
        }

        @Override
        protected TypeToken<List<Mandate>> getTypeToken() {
            return new TypeToken<List<Mandate>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static enum Status {
            PENDING_CUSTOMER_APPROVAL,
            PENDING_SUBMISSION,
            SUBMITTED,
            ACTIVE,
            FAILED,
            CANCELLED,
            EXPIRED,
            CONSUMED,
            BLOCKED,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static final class MandateCreateRequest
    extends IdempotentPostRequest<Mandate> {
        private Links links;
        private Map<String, String> metadata;
        private String payerIpAddress;
        private String reference;
        private String scheme;

        public MandateCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public MandateCreateRequest withLinksCreditor(String creditor) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCreditor(creditor);
            return this;
        }

        public MandateCreateRequest withLinksCustomerBankAccount(String customerBankAccount) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCustomerBankAccount(customerBankAccount);
            return this;
        }

        public MandateCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public MandateCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public MandateCreateRequest withPayerIpAddress(String payerIpAddress) {
            this.payerIpAddress = payerIpAddress;
            return this;
        }

        public MandateCreateRequest withReference(String reference) {
            this.reference = reference;
            return this;
        }

        public MandateCreateRequest withScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public MandateCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<Mandate> handleConflict(HttpClient httpClient, String id) {
            MandateGetRequest request = new MandateGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private MandateCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public MandateCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "mandates";
        }

        @Override
        protected String getEnvelope() {
            return "mandates";
        }

        @Override
        protected Class<Mandate> getResponseClass() {
            return Mandate.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String creditor;
            private String customerBankAccount;

            public Links withCreditor(String creditor) {
                this.creditor = creditor;
                return this;
            }

            public Links withCustomerBankAccount(String customerBankAccount) {
                this.customerBankAccount = customerBankAccount;
                return this;
            }
        }
    }
}

