/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.PayerAuthorisation;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class PayerAuthorisationService {
    private final HttpClient httpClient;

    public PayerAuthorisationService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public PayerAuthorisationGetRequest get(String identity) {
        return new PayerAuthorisationGetRequest(this.httpClient, identity);
    }

    public PayerAuthorisationCreateRequest create() {
        return new PayerAuthorisationCreateRequest(this.httpClient);
    }

    public PayerAuthorisationUpdateRequest update(String identity) {
        return new PayerAuthorisationUpdateRequest(this.httpClient, identity);
    }

    public PayerAuthorisationSubmitRequest submit(String identity) {
        return new PayerAuthorisationSubmitRequest(this.httpClient, identity);
    }

    public PayerAuthorisationConfirmRequest confirm(String identity) {
        return new PayerAuthorisationConfirmRequest(this.httpClient, identity);
    }

    public static final class PayerAuthorisationConfirmRequest
    extends PostRequest<PayerAuthorisation> {
        @PathParam
        private final String identity;

        private PayerAuthorisationConfirmRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PayerAuthorisationConfirmRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payer_authorisations/:identity/actions/confirm";
        }

        @Override
        protected String getEnvelope() {
            return "payer_authorisations";
        }

        @Override
        protected Class<PayerAuthorisation> getResponseClass() {
            return PayerAuthorisation.class;
        }

        @Override
        protected boolean hasBody() {
            return false;
        }
    }

    public static final class PayerAuthorisationSubmitRequest
    extends PostRequest<PayerAuthorisation> {
        @PathParam
        private final String identity;

        private PayerAuthorisationSubmitRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PayerAuthorisationSubmitRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payer_authorisations/:identity/actions/submit";
        }

        @Override
        protected String getEnvelope() {
            return "payer_authorisations";
        }

        @Override
        protected Class<PayerAuthorisation> getResponseClass() {
            return PayerAuthorisation.class;
        }

        @Override
        protected boolean hasBody() {
            return false;
        }
    }

    public static final class PayerAuthorisationUpdateRequest
    extends PutRequest<PayerAuthorisation> {
        @PathParam
        private final String identity;
        private BankAccount bankAccount;
        private Customer customer;
        private Mandate mandate;

        public PayerAuthorisationUpdateRequest withBankAccount(BankAccount bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountAccountHolderName(String accountHolderName) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountHolderName(accountHolderName);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountAccountNumber(String accountNumber) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountNumber(accountNumber);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountAccountNumberEnding(String accountNumberEnding) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountNumberEnding(accountNumberEnding);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountAccountNumberSuffix(String accountNumberSuffix) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountNumberSuffix(accountNumberSuffix);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountAccountType(BankAccount.AccountType accountType) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountType(accountType);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountBankCode(String bankCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withBankCode(bankCode);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountBranchCode(String branchCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withBranchCode(branchCode);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountCountryCode(String countryCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withCountryCode(countryCode);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountCurrency(String currency) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withCurrency(currency);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountIban(String iban) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withIban(iban);
            return this;
        }

        public PayerAuthorisationUpdateRequest withBankAccountMetadata(Map<String, String> metadata) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withMetadata(metadata);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerAddressLine1(String addressLine1) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine1(addressLine1);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerAddressLine2(String addressLine2) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine2(addressLine2);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerAddressLine3(String addressLine3) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine3(addressLine3);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerCity(String city) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCity(city);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerCompanyName(String companyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCompanyName(companyName);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerCountryCode(String countryCode) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCountryCode(countryCode);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerDanishIdentityNumber(String danishIdentityNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withDanishIdentityNumber(danishIdentityNumber);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerEmail(String email) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withEmail(email);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerFamilyName(String familyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withFamilyName(familyName);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerGivenName(String givenName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withGivenName(givenName);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerLocale(String locale) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withLocale(locale);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerMetadata(Map<String, String> metadata) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withMetadata(metadata);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerPostalCode(String postalCode) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withPostalCode(postalCode);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerRegion(String region) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withRegion(region);
            return this;
        }

        public PayerAuthorisationUpdateRequest withCustomerSwedishIdentityNumber(String swedishIdentityNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withSwedishIdentityNumber(swedishIdentityNumber);
            return this;
        }

        public PayerAuthorisationUpdateRequest withMandate(Mandate mandate) {
            this.mandate = mandate;
            return this;
        }

        public PayerAuthorisationUpdateRequest withMandateMetadata(Map<String, String> metadata) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withMetadata(metadata);
            return this;
        }

        public PayerAuthorisationUpdateRequest withMandatePayerIpAddress(String payerIpAddress) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withPayerIpAddress(payerIpAddress);
            return this;
        }

        public PayerAuthorisationUpdateRequest withMandateReference(String reference) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withReference(reference);
            return this;
        }

        public PayerAuthorisationUpdateRequest withMandateScheme(Mandate.Scheme scheme) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withScheme(scheme);
            return this;
        }

        private PayerAuthorisationUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PayerAuthorisationUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payer_authorisations/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "payer_authorisations";
        }

        @Override
        protected Class<PayerAuthorisation> getResponseClass() {
            return PayerAuthorisation.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Mandate {
            private Map<String, String> metadata;
            private String payerIpAddress;
            private String reference;
            private Scheme scheme;

            public Mandate withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Mandate withPayerIpAddress(String payerIpAddress) {
                this.payerIpAddress = payerIpAddress;
                return this;
            }

            public Mandate withReference(String reference) {
                this.reference = reference;
                return this;
            }

            public Mandate withScheme(Scheme scheme) {
                this.scheme = scheme;
                return this;
            }

            public static enum Scheme {
                ACH,
                AUTOGIRO,
                BACS,
                BECS,
                BECS_NZ,
                BETALINGSSERVICE,
                PAD,
                SEPA_CORE,
                UNKNOWN;


                public String toString() {
                    return this.name().toLowerCase();
                }
            }
        }

        public static class Customer {
            private String addressLine1;
            private String addressLine2;
            private String addressLine3;
            private String city;
            private String companyName;
            private String countryCode;
            private String danishIdentityNumber;
            private String email;
            private String familyName;
            private String givenName;
            private String locale;
            private Map<String, String> metadata;
            private String postalCode;
            private String region;
            private String swedishIdentityNumber;

            public Customer withAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            public Customer withAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            public Customer withAddressLine3(String addressLine3) {
                this.addressLine3 = addressLine3;
                return this;
            }

            public Customer withCity(String city) {
                this.city = city;
                return this;
            }

            public Customer withCompanyName(String companyName) {
                this.companyName = companyName;
                return this;
            }

            public Customer withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public Customer withDanishIdentityNumber(String danishIdentityNumber) {
                this.danishIdentityNumber = danishIdentityNumber;
                return this;
            }

            public Customer withEmail(String email) {
                this.email = email;
                return this;
            }

            public Customer withFamilyName(String familyName) {
                this.familyName = familyName;
                return this;
            }

            public Customer withGivenName(String givenName) {
                this.givenName = givenName;
                return this;
            }

            public Customer withLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public Customer withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Customer withPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public Customer withRegion(String region) {
                this.region = region;
                return this;
            }

            public Customer withSwedishIdentityNumber(String swedishIdentityNumber) {
                this.swedishIdentityNumber = swedishIdentityNumber;
                return this;
            }
        }

        public static class BankAccount {
            private String accountHolderName;
            private String accountNumber;
            private String accountNumberEnding;
            private String accountNumberSuffix;
            private AccountType accountType;
            private String bankCode;
            private String branchCode;
            private String countryCode;
            private String currency;
            private String iban;
            private Map<String, String> metadata;

            public BankAccount withAccountHolderName(String accountHolderName) {
                this.accountHolderName = accountHolderName;
                return this;
            }

            public BankAccount withAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
                return this;
            }

            public BankAccount withAccountNumberEnding(String accountNumberEnding) {
                this.accountNumberEnding = accountNumberEnding;
                return this;
            }

            public BankAccount withAccountNumberSuffix(String accountNumberSuffix) {
                this.accountNumberSuffix = accountNumberSuffix;
                return this;
            }

            public BankAccount withAccountType(AccountType accountType) {
                this.accountType = accountType;
                return this;
            }

            public BankAccount withBankCode(String bankCode) {
                this.bankCode = bankCode;
                return this;
            }

            public BankAccount withBranchCode(String branchCode) {
                this.branchCode = branchCode;
                return this;
            }

            public BankAccount withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public BankAccount withCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public BankAccount withIban(String iban) {
                this.iban = iban;
                return this;
            }

            public BankAccount withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public static enum AccountType {
                SAVINGS,
                CHECKING,
                UNKNOWN;


                public String toString() {
                    return this.name().toLowerCase();
                }
            }
        }
    }

    public static final class PayerAuthorisationCreateRequest
    extends IdempotentPostRequest<PayerAuthorisation> {
        private BankAccount bankAccount;
        private Customer customer;
        private Mandate mandate;

        public PayerAuthorisationCreateRequest withBankAccount(BankAccount bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountAccountHolderName(String accountHolderName) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountHolderName(accountHolderName);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountAccountNumber(String accountNumber) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountNumber(accountNumber);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountAccountNumberEnding(String accountNumberEnding) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountNumberEnding(accountNumberEnding);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountAccountNumberSuffix(String accountNumberSuffix) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountNumberSuffix(accountNumberSuffix);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountAccountType(BankAccount.AccountType accountType) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withAccountType(accountType);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountBankCode(String bankCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withBankCode(bankCode);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountBranchCode(String branchCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withBranchCode(branchCode);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountCountryCode(String countryCode) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withCountryCode(countryCode);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountCurrency(String currency) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withCurrency(currency);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountIban(String iban) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withIban(iban);
            return this;
        }

        public PayerAuthorisationCreateRequest withBankAccountMetadata(Map<String, String> metadata) {
            if (this.bankAccount == null) {
                this.bankAccount = new BankAccount();
            }
            this.bankAccount.withMetadata(metadata);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerAddressLine1(String addressLine1) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine1(addressLine1);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerAddressLine2(String addressLine2) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine2(addressLine2);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerAddressLine3(String addressLine3) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withAddressLine3(addressLine3);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerCity(String city) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCity(city);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerCompanyName(String companyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCompanyName(companyName);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerCountryCode(String countryCode) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withCountryCode(countryCode);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerDanishIdentityNumber(String danishIdentityNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withDanishIdentityNumber(danishIdentityNumber);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerEmail(String email) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withEmail(email);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerFamilyName(String familyName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withFamilyName(familyName);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerGivenName(String givenName) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withGivenName(givenName);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerLocale(String locale) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withLocale(locale);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerMetadata(Map<String, String> metadata) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withMetadata(metadata);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerPostalCode(String postalCode) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withPostalCode(postalCode);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerRegion(String region) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withRegion(region);
            return this;
        }

        public PayerAuthorisationCreateRequest withCustomerSwedishIdentityNumber(String swedishIdentityNumber) {
            if (this.customer == null) {
                this.customer = new Customer();
            }
            this.customer.withSwedishIdentityNumber(swedishIdentityNumber);
            return this;
        }

        public PayerAuthorisationCreateRequest withMandate(Mandate mandate) {
            this.mandate = mandate;
            return this;
        }

        public PayerAuthorisationCreateRequest withMandateMetadata(Map<String, String> metadata) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withMetadata(metadata);
            return this;
        }

        public PayerAuthorisationCreateRequest withMandatePayerIpAddress(String payerIpAddress) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withPayerIpAddress(payerIpAddress);
            return this;
        }

        public PayerAuthorisationCreateRequest withMandateReference(String reference) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withReference(reference);
            return this;
        }

        public PayerAuthorisationCreateRequest withMandateScheme(Mandate.Scheme scheme) {
            if (this.mandate == null) {
                this.mandate = new Mandate();
            }
            this.mandate.withScheme(scheme);
            return this;
        }

        public PayerAuthorisationCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<PayerAuthorisation> handleConflict(HttpClient httpClient, String id) {
            PayerAuthorisationGetRequest request = new PayerAuthorisationGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private PayerAuthorisationCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public PayerAuthorisationCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "payer_authorisations";
        }

        @Override
        protected String getEnvelope() {
            return "payer_authorisations";
        }

        @Override
        protected Class<PayerAuthorisation> getResponseClass() {
            return PayerAuthorisation.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Mandate {
            private Map<String, String> metadata;
            private String payerIpAddress;
            private String reference;
            private Scheme scheme;

            public Mandate withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Mandate withPayerIpAddress(String payerIpAddress) {
                this.payerIpAddress = payerIpAddress;
                return this;
            }

            public Mandate withReference(String reference) {
                this.reference = reference;
                return this;
            }

            public Mandate withScheme(Scheme scheme) {
                this.scheme = scheme;
                return this;
            }

            public static enum Scheme {
                ACH,
                AUTOGIRO,
                BACS,
                BECS,
                BECS_NZ,
                BETALINGSSERVICE,
                PAD,
                SEPA_CORE,
                UNKNOWN;


                public String toString() {
                    return this.name().toLowerCase();
                }
            }
        }

        public static class Customer {
            private String addressLine1;
            private String addressLine2;
            private String addressLine3;
            private String city;
            private String companyName;
            private String countryCode;
            private String danishIdentityNumber;
            private String email;
            private String familyName;
            private String givenName;
            private String locale;
            private Map<String, String> metadata;
            private String postalCode;
            private String region;
            private String swedishIdentityNumber;

            public Customer withAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            public Customer withAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            public Customer withAddressLine3(String addressLine3) {
                this.addressLine3 = addressLine3;
                return this;
            }

            public Customer withCity(String city) {
                this.city = city;
                return this;
            }

            public Customer withCompanyName(String companyName) {
                this.companyName = companyName;
                return this;
            }

            public Customer withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public Customer withDanishIdentityNumber(String danishIdentityNumber) {
                this.danishIdentityNumber = danishIdentityNumber;
                return this;
            }

            public Customer withEmail(String email) {
                this.email = email;
                return this;
            }

            public Customer withFamilyName(String familyName) {
                this.familyName = familyName;
                return this;
            }

            public Customer withGivenName(String givenName) {
                this.givenName = givenName;
                return this;
            }

            public Customer withLocale(String locale) {
                this.locale = locale;
                return this;
            }

            public Customer withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Customer withPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public Customer withRegion(String region) {
                this.region = region;
                return this;
            }

            public Customer withSwedishIdentityNumber(String swedishIdentityNumber) {
                this.swedishIdentityNumber = swedishIdentityNumber;
                return this;
            }
        }

        public static class BankAccount {
            private String accountHolderName;
            private String accountNumber;
            private String accountNumberEnding;
            private String accountNumberSuffix;
            private AccountType accountType;
            private String bankCode;
            private String branchCode;
            private String countryCode;
            private String currency;
            private String iban;
            private Map<String, String> metadata;

            public BankAccount withAccountHolderName(String accountHolderName) {
                this.accountHolderName = accountHolderName;
                return this;
            }

            public BankAccount withAccountNumber(String accountNumber) {
                this.accountNumber = accountNumber;
                return this;
            }

            public BankAccount withAccountNumberEnding(String accountNumberEnding) {
                this.accountNumberEnding = accountNumberEnding;
                return this;
            }

            public BankAccount withAccountNumberSuffix(String accountNumberSuffix) {
                this.accountNumberSuffix = accountNumberSuffix;
                return this;
            }

            public BankAccount withAccountType(AccountType accountType) {
                this.accountType = accountType;
                return this;
            }

            public BankAccount withBankCode(String bankCode) {
                this.bankCode = bankCode;
                return this;
            }

            public BankAccount withBranchCode(String branchCode) {
                this.branchCode = branchCode;
                return this;
            }

            public BankAccount withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public BankAccount withCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public BankAccount withIban(String iban) {
                this.iban = iban;
                return this;
            }

            public BankAccount withMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
                return this;
            }

            public static enum AccountType {
                SAVINGS,
                CHECKING,
                UNKNOWN;


                public String toString() {
                    return this.name().toLowerCase();
                }
            }
        }
    }

    public static final class PayerAuthorisationGetRequest
    extends GetRequest<PayerAuthorisation> {
        @PathParam
        private final String identity;

        private PayerAuthorisationGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PayerAuthorisationGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payer_authorisations/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "payer_authorisations";
        }

        @Override
        protected Class<PayerAuthorisation> getResponseClass() {
            return PayerAuthorisation.class;
        }
    }
}

