/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.Payment;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaymentService {
    private final HttpClient httpClient;

    public PaymentService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public PaymentCreateRequest create() {
        return new PaymentCreateRequest(this.httpClient);
    }

    public PaymentListRequest<ListResponse<Payment>> list() {
        return new PaymentListRequest<ListResponse<Payment>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public PaymentListRequest<Iterable<Payment>> all() {
        return new PaymentListRequest<Iterable<Payment>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public PaymentGetRequest get(String identity) {
        return new PaymentGetRequest(this.httpClient, identity);
    }

    public PaymentUpdateRequest update(String identity) {
        return new PaymentUpdateRequest(this.httpClient, identity);
    }

    public PaymentCancelRequest cancel(String identity) {
        return new PaymentCancelRequest(this.httpClient, identity);
    }

    public PaymentRetryRequest retry(String identity) {
        return new PaymentRetryRequest(this.httpClient, identity);
    }

    public static final class PaymentRetryRequest
    extends PostRequest<Payment> {
        @PathParam
        private final String identity;
        private String chargeDate;
        private Map<String, String> metadata;

        public PaymentRetryRequest withChargeDate(String chargeDate) {
            this.chargeDate = chargeDate;
            return this;
        }

        public PaymentRetryRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PaymentRetryRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private PaymentRetryRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PaymentRetryRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payments/:identity/actions/retry";
        }

        @Override
        protected String getEnvelope() {
            return "payments";
        }

        @Override
        protected Class<Payment> getResponseClass() {
            return Payment.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class PaymentCancelRequest
    extends PostRequest<Payment> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public PaymentCancelRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PaymentCancelRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private PaymentCancelRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PaymentCancelRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payments/:identity/actions/cancel";
        }

        @Override
        protected String getEnvelope() {
            return "payments";
        }

        @Override
        protected Class<Payment> getResponseClass() {
            return Payment.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class PaymentUpdateRequest
    extends PutRequest<Payment> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;
        private Boolean retryIfPossible;

        public PaymentUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PaymentUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public PaymentUpdateRequest withRetryIfPossible(Boolean retryIfPossible) {
            this.retryIfPossible = retryIfPossible;
            return this;
        }

        private PaymentUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PaymentUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payments/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "payments";
        }

        @Override
        protected Class<Payment> getResponseClass() {
            return Payment.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class PaymentGetRequest
    extends GetRequest<Payment> {
        @PathParam
        private final String identity;

        private PaymentGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PaymentGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payments/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "payments";
        }

        @Override
        protected Class<Payment> getResponseClass() {
            return Payment.class;
        }
    }

    public static final class PaymentListRequest<S>
    extends ListRequest<S, Payment> {
        private ChargeDate chargeDate;
        private CreatedAt createdAt;
        private String creditor;
        private Currency currency;
        private String customer;
        private String mandate;
        private SortDirection sortDirection;
        private SortField sortField;
        private Status status;
        private String subscription;

        public PaymentListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public PaymentListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public PaymentListRequest<S> withChargeDate(ChargeDate chargeDate) {
            this.chargeDate = chargeDate;
            return this;
        }

        public PaymentListRequest<S> withChargeDateGt(String gt) {
            if (this.chargeDate == null) {
                this.chargeDate = new ChargeDate();
            }
            this.chargeDate.withGt(gt);
            return this;
        }

        public PaymentListRequest<S> withChargeDateGte(String gte) {
            if (this.chargeDate == null) {
                this.chargeDate = new ChargeDate();
            }
            this.chargeDate.withGte(gte);
            return this;
        }

        public PaymentListRequest<S> withChargeDateLt(String lt) {
            if (this.chargeDate == null) {
                this.chargeDate = new ChargeDate();
            }
            this.chargeDate.withLt(lt);
            return this;
        }

        public PaymentListRequest<S> withChargeDateLte(String lte) {
            if (this.chargeDate == null) {
                this.chargeDate = new ChargeDate();
            }
            this.chargeDate.withLte(lte);
            return this;
        }

        public PaymentListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public PaymentListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public PaymentListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public PaymentListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public PaymentListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public PaymentListRequest<S> withCreditor(String creditor) {
            this.creditor = creditor;
            return this;
        }

        public PaymentListRequest<S> withCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public PaymentListRequest<S> withCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public PaymentListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public PaymentListRequest<S> withMandate(String mandate) {
            this.mandate = mandate;
            return this;
        }

        public PaymentListRequest<S> withSortDirection(SortDirection sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public PaymentListRequest<S> withSortField(SortField sortField) {
            this.sortField = sortField;
            return this;
        }

        public PaymentListRequest<S> withStatus(Status status) {
            this.status = status;
            return this;
        }

        public PaymentListRequest<S> withSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private PaymentListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Payment> executor) {
            super(httpClient, executor);
        }

        public PaymentListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.chargeDate != null) {
                params.putAll(this.chargeDate.getQueryParams());
            }
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.creditor != null) {
                params.put((Object)"creditor", (Object)this.creditor);
            }
            if (this.currency != null) {
                params.put((Object)"currency", (Object)this.currency);
            }
            if (this.customer != null) {
                params.put((Object)"customer", (Object)this.customer);
            }
            if (this.mandate != null) {
                params.put((Object)"mandate", (Object)this.mandate);
            }
            if (this.sortDirection != null) {
                params.put((Object)"sort_direction", (Object)this.sortDirection);
            }
            if (this.sortField != null) {
                params.put((Object)"sort_field", (Object)this.sortField);
            }
            if (this.status != null) {
                params.put((Object)"status", (Object)this.status);
            }
            if (this.subscription != null) {
                params.put((Object)"subscription", (Object)this.subscription);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payments";
        }

        @Override
        protected String getEnvelope() {
            return "payments";
        }

        @Override
        protected TypeToken<List<Payment>> getTypeToken() {
            return new TypeToken<List<Payment>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static class ChargeDate {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public ChargeDate withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public ChargeDate withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public ChargeDate withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public ChargeDate withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"charge_date[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"charge_date[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"charge_date[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"charge_date[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static enum Status {
            PENDING_CUSTOMER_APPROVAL,
            PENDING_SUBMISSION,
            SUBMITTED,
            CONFIRMED,
            PAID_OUT,
            CANCELLED,
            CUSTOMER_APPROVAL_DENIED,
            FAILED,
            CHARGED_BACK,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum SortField {
            CHARGE_DATE,
            AMOUNT,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum SortDirection {
            ASC,
            DESC,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum Currency {
            AUD,
            CAD,
            DKK,
            EUR,
            GBP,
            NZD,
            SEK,
            USD,
            UNKNOWN;


            public String toString() {
                return this.name();
            }
        }
    }

    public static final class PaymentCreateRequest
    extends IdempotentPostRequest<Payment> {
        private Integer amount;
        private Integer appFee;
        private String chargeDate;
        private Currency currency;
        private String description;
        private Links links;
        private Map<String, String> metadata;
        private String reference;
        private Boolean retryIfPossible;

        public PaymentCreateRequest withAmount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public PaymentCreateRequest withAppFee(Integer appFee) {
            this.appFee = appFee;
            return this;
        }

        public PaymentCreateRequest withChargeDate(String chargeDate) {
            this.chargeDate = chargeDate;
            return this;
        }

        public PaymentCreateRequest withCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public PaymentCreateRequest withDescription(String description) {
            this.description = description;
            return this;
        }

        public PaymentCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public PaymentCreateRequest withLinksMandate(String mandate) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withMandate(mandate);
            return this;
        }

        public PaymentCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PaymentCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public PaymentCreateRequest withReference(String reference) {
            this.reference = reference;
            return this;
        }

        public PaymentCreateRequest withRetryIfPossible(Boolean retryIfPossible) {
            this.retryIfPossible = retryIfPossible;
            return this;
        }

        public PaymentCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<Payment> handleConflict(HttpClient httpClient, String id) {
            PaymentGetRequest request = new PaymentGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private PaymentCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public PaymentCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "payments";
        }

        @Override
        protected String getEnvelope() {
            return "payments";
        }

        @Override
        protected Class<Payment> getResponseClass() {
            return Payment.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String mandate;

            public Links withMandate(String mandate) {
                this.mandate = mandate;
                return this;
            }
        }

        public static enum Currency {
            AUD,
            CAD,
            DKK,
            EUR,
            GBP,
            NZD,
            SEK,
            USD,
            UNKNOWN;


            public String toString() {
                return this.name();
            }
        }
    }
}

