/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.HttpClient;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.resources.PayoutItem;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class PayoutItemService {
    private final HttpClient httpClient;

    public PayoutItemService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public PayoutItemListRequest<ListResponse<PayoutItem>> list() {
        return new PayoutItemListRequest<ListResponse<PayoutItem>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public PayoutItemListRequest<Iterable<PayoutItem>> all() {
        return new PayoutItemListRequest<Iterable<PayoutItem>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public static final class PayoutItemListRequest<S>
    extends ListRequest<S, PayoutItem> {
        private Include2020TaxCutover include2020TaxCutover;
        private String payout;

        public PayoutItemListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public PayoutItemListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public PayoutItemListRequest<S> withInclude2020TaxCutover(Include2020TaxCutover include2020TaxCutover) {
            this.include2020TaxCutover = include2020TaxCutover;
            return this;
        }

        public PayoutItemListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public PayoutItemListRequest<S> withPayout(String payout) {
            this.payout = payout;
            return this;
        }

        private PayoutItemListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, PayoutItem> executor) {
            super(httpClient, executor);
        }

        public PayoutItemListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.include2020TaxCutover != null) {
                params.put((Object)"include_2020_tax_cutover", (Object)this.include2020TaxCutover);
            }
            if (this.payout != null) {
                params.put((Object)"payout", (Object)this.payout);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payout_items";
        }

        @Override
        protected String getEnvelope() {
            return "payout_items";
        }

        @Override
        protected TypeToken<List<PayoutItem>> getTypeToken() {
            return new TypeToken<List<PayoutItem>>(){};
        }

        public static enum Include2020TaxCutover {
            TRUE,
            FALSE,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

