/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.Payout;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PayoutService {
    private final HttpClient httpClient;

    public PayoutService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public PayoutListRequest<ListResponse<Payout>> list() {
        return new PayoutListRequest<ListResponse<Payout>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public PayoutListRequest<Iterable<Payout>> all() {
        return new PayoutListRequest<Iterable<Payout>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public PayoutGetRequest get(String identity) {
        return new PayoutGetRequest(this.httpClient, identity);
    }

    public PayoutUpdateRequest update(String identity) {
        return new PayoutUpdateRequest(this.httpClient, identity);
    }

    public static final class PayoutUpdateRequest
    extends PutRequest<Payout> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public PayoutUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PayoutUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private PayoutUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PayoutUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payouts/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "payouts";
        }

        @Override
        protected Class<Payout> getResponseClass() {
            return Payout.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class PayoutGetRequest
    extends GetRequest<Payout> {
        @PathParam
        private final String identity;

        private PayoutGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public PayoutGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payouts/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "payouts";
        }

        @Override
        protected Class<Payout> getResponseClass() {
            return Payout.class;
        }
    }

    public static final class PayoutListRequest<S>
    extends ListRequest<S, Payout> {
        private CreatedAt createdAt;
        private String creditor;
        private String creditorBankAccount;
        private Currency currency;
        private Map<String, String> metadata;
        private PayoutType payoutType;
        private String reference;
        private Status status;

        public PayoutListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public PayoutListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public PayoutListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public PayoutListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public PayoutListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public PayoutListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public PayoutListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public PayoutListRequest<S> withCreditor(String creditor) {
            this.creditor = creditor;
            return this;
        }

        public PayoutListRequest<S> withCreditorBankAccount(String creditorBankAccount) {
            this.creditorBankAccount = creditorBankAccount;
            return this;
        }

        public PayoutListRequest<S> withCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public PayoutListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public PayoutListRequest<S> withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public PayoutListRequest<S> withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public PayoutListRequest<S> withPayoutType(PayoutType payoutType) {
            this.payoutType = payoutType;
            return this;
        }

        public PayoutListRequest<S> withReference(String reference) {
            this.reference = reference;
            return this;
        }

        public PayoutListRequest<S> withStatus(Status status) {
            this.status = status;
            return this;
        }

        private PayoutListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Payout> executor) {
            super(httpClient, executor);
        }

        public PayoutListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.creditor != null) {
                params.put((Object)"creditor", (Object)this.creditor);
            }
            if (this.creditorBankAccount != null) {
                params.put((Object)"creditor_bank_account", (Object)this.creditorBankAccount);
            }
            if (this.currency != null) {
                params.put((Object)"currency", (Object)this.currency);
            }
            if (this.metadata != null) {
                params.put((Object)"metadata", this.metadata);
            }
            if (this.payoutType != null) {
                params.put((Object)"payout_type", (Object)this.payoutType);
            }
            if (this.reference != null) {
                params.put((Object)"reference", (Object)this.reference);
            }
            if (this.status != null) {
                params.put((Object)"status", (Object)this.status);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "payouts";
        }

        @Override
        protected String getEnvelope() {
            return "payouts";
        }

        @Override
        protected TypeToken<List<Payout>> getTypeToken() {
            return new TypeToken<List<Payout>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static enum Status {
            PENDING,
            PAID,
            BOUNCED,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum PayoutType {
            MERCHANT,
            PARTNER,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum Currency {
            AUD,
            CAD,
            DKK,
            EUR,
            GBP,
            NZD,
            SEK,
            USD,
            UNKNOWN;


            public String toString() {
                return this.name();
            }
        }
    }
}

