/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.resources.RedirectFlow;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class RedirectFlowService {
    private final HttpClient httpClient;

    public RedirectFlowService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public RedirectFlowCreateRequest create() {
        return new RedirectFlowCreateRequest(this.httpClient);
    }

    public RedirectFlowGetRequest get(String identity) {
        return new RedirectFlowGetRequest(this.httpClient, identity);
    }

    public RedirectFlowCompleteRequest complete(String identity) {
        return new RedirectFlowCompleteRequest(this.httpClient, identity);
    }

    public static final class RedirectFlowCompleteRequest
    extends PostRequest<RedirectFlow> {
        @PathParam
        private final String identity;
        private String sessionToken;

        public RedirectFlowCompleteRequest withSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        private RedirectFlowCompleteRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public RedirectFlowCompleteRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "redirect_flows/:identity/actions/complete";
        }

        @Override
        protected String getEnvelope() {
            return "redirect_flows";
        }

        @Override
        protected Class<RedirectFlow> getResponseClass() {
            return RedirectFlow.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class RedirectFlowGetRequest
    extends GetRequest<RedirectFlow> {
        @PathParam
        private final String identity;

        private RedirectFlowGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public RedirectFlowGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "redirect_flows/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "redirect_flows";
        }

        @Override
        protected Class<RedirectFlow> getResponseClass() {
            return RedirectFlow.class;
        }
    }

    public static final class RedirectFlowCreateRequest
    extends IdempotentPostRequest<RedirectFlow> {
        private String description;
        private Links links;
        private Map<String, String> metadata;
        private PrefilledBankAccount prefilledBankAccount;
        private PrefilledCustomer prefilledCustomer;
        private Scheme scheme;
        private String sessionToken;
        private String successRedirectUrl;

        public RedirectFlowCreateRequest withDescription(String description) {
            this.description = description;
            return this;
        }

        public RedirectFlowCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public RedirectFlowCreateRequest withLinksCreditor(String creditor) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withCreditor(creditor);
            return this;
        }

        public RedirectFlowCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public RedirectFlowCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledBankAccount(PrefilledBankAccount prefilledBankAccount) {
            this.prefilledBankAccount = prefilledBankAccount;
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledBankAccountAccountType(PrefilledBankAccount.AccountType accountType) {
            if (this.prefilledBankAccount == null) {
                this.prefilledBankAccount = new PrefilledBankAccount();
            }
            this.prefilledBankAccount.withAccountType(accountType);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomer(PrefilledCustomer prefilledCustomer) {
            this.prefilledCustomer = prefilledCustomer;
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerAddressLine1(String addressLine1) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withAddressLine1(addressLine1);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerAddressLine2(String addressLine2) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withAddressLine2(addressLine2);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerAddressLine3(String addressLine3) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withAddressLine3(addressLine3);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerCity(String city) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withCity(city);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerCompanyName(String companyName) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withCompanyName(companyName);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerCountryCode(String countryCode) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withCountryCode(countryCode);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerDanishIdentityNumber(String danishIdentityNumber) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withDanishIdentityNumber(danishIdentityNumber);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerEmail(String email) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withEmail(email);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerFamilyName(String familyName) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withFamilyName(familyName);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerGivenName(String givenName) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withGivenName(givenName);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerLanguage(String language) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withLanguage(language);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerPhoneNumber(String phoneNumber) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withPhoneNumber(phoneNumber);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerPostalCode(String postalCode) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withPostalCode(postalCode);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerRegion(String region) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withRegion(region);
            return this;
        }

        public RedirectFlowCreateRequest withPrefilledCustomerSwedishIdentityNumber(String swedishIdentityNumber) {
            if (this.prefilledCustomer == null) {
                this.prefilledCustomer = new PrefilledCustomer();
            }
            this.prefilledCustomer.withSwedishIdentityNumber(swedishIdentityNumber);
            return this;
        }

        public RedirectFlowCreateRequest withScheme(Scheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public RedirectFlowCreateRequest withSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public RedirectFlowCreateRequest withSuccessRedirectUrl(String successRedirectUrl) {
            this.successRedirectUrl = successRedirectUrl;
            return this;
        }

        public RedirectFlowCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<RedirectFlow> handleConflict(HttpClient httpClient, String id) {
            RedirectFlowGetRequest request = new RedirectFlowGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private RedirectFlowCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public RedirectFlowCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "redirect_flows";
        }

        @Override
        protected String getEnvelope() {
            return "redirect_flows";
        }

        @Override
        protected Class<RedirectFlow> getResponseClass() {
            return RedirectFlow.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class PrefilledCustomer {
            private String addressLine1;
            private String addressLine2;
            private String addressLine3;
            private String city;
            private String companyName;
            private String countryCode;
            private String danishIdentityNumber;
            private String email;
            private String familyName;
            private String givenName;
            private String language;
            private String phoneNumber;
            private String postalCode;
            private String region;
            private String swedishIdentityNumber;

            public PrefilledCustomer withAddressLine1(String addressLine1) {
                this.addressLine1 = addressLine1;
                return this;
            }

            public PrefilledCustomer withAddressLine2(String addressLine2) {
                this.addressLine2 = addressLine2;
                return this;
            }

            public PrefilledCustomer withAddressLine3(String addressLine3) {
                this.addressLine3 = addressLine3;
                return this;
            }

            public PrefilledCustomer withCity(String city) {
                this.city = city;
                return this;
            }

            public PrefilledCustomer withCompanyName(String companyName) {
                this.companyName = companyName;
                return this;
            }

            public PrefilledCustomer withCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public PrefilledCustomer withDanishIdentityNumber(String danishIdentityNumber) {
                this.danishIdentityNumber = danishIdentityNumber;
                return this;
            }

            public PrefilledCustomer withEmail(String email) {
                this.email = email;
                return this;
            }

            public PrefilledCustomer withFamilyName(String familyName) {
                this.familyName = familyName;
                return this;
            }

            public PrefilledCustomer withGivenName(String givenName) {
                this.givenName = givenName;
                return this;
            }

            public PrefilledCustomer withLanguage(String language) {
                this.language = language;
                return this;
            }

            public PrefilledCustomer withPhoneNumber(String phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            public PrefilledCustomer withPostalCode(String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public PrefilledCustomer withRegion(String region) {
                this.region = region;
                return this;
            }

            public PrefilledCustomer withSwedishIdentityNumber(String swedishIdentityNumber) {
                this.swedishIdentityNumber = swedishIdentityNumber;
                return this;
            }
        }

        public static class PrefilledBankAccount {
            private AccountType accountType;

            public PrefilledBankAccount withAccountType(AccountType accountType) {
                this.accountType = accountType;
                return this;
            }

            public static enum AccountType {
                SAVINGS,
                CHECKING,
                UNKNOWN;


                public String toString() {
                    return this.name().toLowerCase();
                }
            }
        }

        public static class Links {
            private String creditor;

            public Links withCreditor(String creditor) {
                this.creditor = creditor;
                return this;
            }
        }

        public static enum Scheme {
            ACH,
            AUTOGIRO,
            BACS,
            BECS,
            BECS_NZ,
            BETALINGSSERVICE,
            PAD,
            SEPA_CORE,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

