/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.Refund;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RefundService {
    private final HttpClient httpClient;

    public RefundService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public RefundCreateRequest create() {
        return new RefundCreateRequest(this.httpClient);
    }

    public RefundListRequest<ListResponse<Refund>> list() {
        return new RefundListRequest<ListResponse<Refund>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public RefundListRequest<Iterable<Refund>> all() {
        return new RefundListRequest<Iterable<Refund>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public RefundGetRequest get(String identity) {
        return new RefundGetRequest(this.httpClient, identity);
    }

    public RefundUpdateRequest update(String identity) {
        return new RefundUpdateRequest(this.httpClient, identity);
    }

    public static final class RefundUpdateRequest
    extends PutRequest<Refund> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public RefundUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public RefundUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private RefundUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public RefundUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "refunds/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "refunds";
        }

        @Override
        protected Class<Refund> getResponseClass() {
            return Refund.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class RefundGetRequest
    extends GetRequest<Refund> {
        @PathParam
        private final String identity;

        private RefundGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public RefundGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "refunds/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "refunds";
        }

        @Override
        protected Class<Refund> getResponseClass() {
            return Refund.class;
        }
    }

    public static final class RefundListRequest<S>
    extends ListRequest<S, Refund> {
        private CreatedAt createdAt;
        private String mandate;
        private String payment;
        private RefundType refundType;

        public RefundListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public RefundListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public RefundListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public RefundListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public RefundListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public RefundListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public RefundListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public RefundListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public RefundListRequest<S> withMandate(String mandate) {
            this.mandate = mandate;
            return this;
        }

        public RefundListRequest<S> withPayment(String payment) {
            this.payment = payment;
            return this;
        }

        public RefundListRequest<S> withRefundType(RefundType refundType) {
            this.refundType = refundType;
            return this;
        }

        private RefundListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Refund> executor) {
            super(httpClient, executor);
        }

        public RefundListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.mandate != null) {
                params.put((Object)"mandate", (Object)this.mandate);
            }
            if (this.payment != null) {
                params.put((Object)"payment", (Object)this.payment);
            }
            if (this.refundType != null) {
                params.put((Object)"refund_type", (Object)this.refundType);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "refunds";
        }

        @Override
        protected String getEnvelope() {
            return "refunds";
        }

        @Override
        protected TypeToken<List<Refund>> getTypeToken() {
            return new TypeToken<List<Refund>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }

        public static enum RefundType {
            MANDATE,
            PAYMENT,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static final class RefundCreateRequest
    extends IdempotentPostRequest<Refund> {
        private Integer amount;
        private Links links;
        private Map<String, String> metadata;
        private String reference;
        private Integer totalAmountConfirmation;

        public RefundCreateRequest withAmount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public RefundCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public RefundCreateRequest withLinksMandate(String mandate) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withMandate(mandate);
            return this;
        }

        public RefundCreateRequest withLinksPayment(String payment) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withPayment(payment);
            return this;
        }

        public RefundCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public RefundCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public RefundCreateRequest withReference(String reference) {
            this.reference = reference;
            return this;
        }

        public RefundCreateRequest withTotalAmountConfirmation(Integer totalAmountConfirmation) {
            this.totalAmountConfirmation = totalAmountConfirmation;
            return this;
        }

        public RefundCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<Refund> handleConflict(HttpClient httpClient, String id) {
            RefundGetRequest request = new RefundGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private RefundCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public RefundCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "refunds";
        }

        @Override
        protected String getEnvelope() {
            return "refunds";
        }

        @Override
        protected Class<Refund> getResponseClass() {
            return Refund.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String mandate;
            private String payment;

            public Links withMandate(String mandate) {
                this.mandate = mandate;
                return this;
            }

            public Links withPayment(String payment) {
                this.payment = payment;
                return this;
            }
        }
    }
}

