/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.IdempotentPostRequest;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.http.PostRequest;
import com.gocardless.http.PutRequest;
import com.gocardless.resources.Subscription;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubscriptionService {
    private final HttpClient httpClient;

    public SubscriptionService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public SubscriptionCreateRequest create() {
        return new SubscriptionCreateRequest(this.httpClient);
    }

    public SubscriptionListRequest<ListResponse<Subscription>> list() {
        return new SubscriptionListRequest<ListResponse<Subscription>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public SubscriptionListRequest<Iterable<Subscription>> all() {
        return new SubscriptionListRequest<Iterable<Subscription>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public SubscriptionGetRequest get(String identity) {
        return new SubscriptionGetRequest(this.httpClient, identity);
    }

    public SubscriptionUpdateRequest update(String identity) {
        return new SubscriptionUpdateRequest(this.httpClient, identity);
    }

    public SubscriptionPauseRequest pause(String identity) {
        return new SubscriptionPauseRequest(this.httpClient, identity);
    }

    public SubscriptionResumeRequest resume(String identity) {
        return new SubscriptionResumeRequest(this.httpClient, identity);
    }

    public SubscriptionCancelRequest cancel(String identity) {
        return new SubscriptionCancelRequest(this.httpClient, identity);
    }

    public static final class SubscriptionCancelRequest
    extends PostRequest<Subscription> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public SubscriptionCancelRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionCancelRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private SubscriptionCancelRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public SubscriptionCancelRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "subscriptions/:identity/actions/cancel";
        }

        @Override
        protected String getEnvelope() {
            return "subscriptions";
        }

        @Override
        protected Class<Subscription> getResponseClass() {
            return Subscription.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class SubscriptionResumeRequest
    extends PostRequest<Subscription> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;

        public SubscriptionResumeRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionResumeRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        private SubscriptionResumeRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public SubscriptionResumeRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "subscriptions/:identity/actions/resume";
        }

        @Override
        protected String getEnvelope() {
            return "subscriptions";
        }

        @Override
        protected Class<Subscription> getResponseClass() {
            return Subscription.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class SubscriptionPauseRequest
    extends PostRequest<Subscription> {
        @PathParam
        private final String identity;
        private Map<String, String> metadata;
        private Integer pauseCycles;

        public SubscriptionPauseRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionPauseRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public SubscriptionPauseRequest withPauseCycles(Integer pauseCycles) {
            this.pauseCycles = pauseCycles;
            return this;
        }

        private SubscriptionPauseRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public SubscriptionPauseRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "subscriptions/:identity/actions/pause";
        }

        @Override
        protected String getEnvelope() {
            return "subscriptions";
        }

        @Override
        protected Class<Subscription> getResponseClass() {
            return Subscription.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        @Override
        protected String getRequestEnvelope() {
            return "data";
        }
    }

    public static final class SubscriptionUpdateRequest
    extends PutRequest<Subscription> {
        @PathParam
        private final String identity;
        private Integer amount;
        private Integer appFee;
        private Map<String, String> metadata;
        private String name;
        private String paymentReference;
        private Boolean retryIfPossible;

        public SubscriptionUpdateRequest withAmount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public SubscriptionUpdateRequest withAppFee(Integer appFee) {
            this.appFee = appFee;
            return this;
        }

        public SubscriptionUpdateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionUpdateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public SubscriptionUpdateRequest withName(String name) {
            this.name = name;
            return this;
        }

        public SubscriptionUpdateRequest withPaymentReference(String paymentReference) {
            this.paymentReference = paymentReference;
            return this;
        }

        public SubscriptionUpdateRequest withRetryIfPossible(Boolean retryIfPossible) {
            this.retryIfPossible = retryIfPossible;
            return this;
        }

        private SubscriptionUpdateRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public SubscriptionUpdateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "subscriptions/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "subscriptions";
        }

        @Override
        protected Class<Subscription> getResponseClass() {
            return Subscription.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }
    }

    public static final class SubscriptionGetRequest
    extends GetRequest<Subscription> {
        @PathParam
        private final String identity;

        private SubscriptionGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public SubscriptionGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "subscriptions/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "subscriptions";
        }

        @Override
        protected Class<Subscription> getResponseClass() {
            return Subscription.class;
        }
    }

    public static final class SubscriptionListRequest<S>
    extends ListRequest<S, Subscription> {
        private CreatedAt createdAt;
        private String customer;
        private String mandate;
        private List<String> status;

        public SubscriptionListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public SubscriptionListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public SubscriptionListRequest<S> withCreatedAt(CreatedAt createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SubscriptionListRequest<S> withCreatedAtGt(String gt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGt(gt);
            return this;
        }

        public SubscriptionListRequest<S> withCreatedAtGte(String gte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withGte(gte);
            return this;
        }

        public SubscriptionListRequest<S> withCreatedAtLt(String lt) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLt(lt);
            return this;
        }

        public SubscriptionListRequest<S> withCreatedAtLte(String lte) {
            if (this.createdAt == null) {
                this.createdAt = new CreatedAt();
            }
            this.createdAt.withLte(lte);
            return this;
        }

        public SubscriptionListRequest<S> withCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public SubscriptionListRequest<S> withLimit(Integer limit) {
            this.setLimit(limit);
            return this;
        }

        public SubscriptionListRequest<S> withMandate(String mandate) {
            this.mandate = mandate;
            return this;
        }

        public SubscriptionListRequest<S> withStatus(List<String> status) {
            this.status = status;
            return this;
        }

        public SubscriptionListRequest<S> withStatus(String status) {
            if (this.status == null) {
                this.status = new ArrayList<String>();
            }
            this.status.add(status);
            return this;
        }

        private SubscriptionListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, Subscription> executor) {
            super(httpClient, executor);
        }

        public SubscriptionListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.createdAt != null) {
                params.putAll(this.createdAt.getQueryParams());
            }
            if (this.customer != null) {
                params.put((Object)"customer", (Object)this.customer);
            }
            if (this.mandate != null) {
                params.put((Object)"mandate", (Object)this.mandate);
            }
            if (this.status != null) {
                params.put((Object)"status", (Object)Joiner.on((String)",").join(this.status));
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "subscriptions";
        }

        @Override
        protected String getEnvelope() {
            return "subscriptions";
        }

        @Override
        protected TypeToken<List<Subscription>> getTypeToken() {
            return new TypeToken<List<Subscription>>(){};
        }

        public static class CreatedAt {
            private String gt;
            private String gte;
            private String lt;
            private String lte;

            public CreatedAt withGt(String gt) {
                this.gt = gt;
                return this;
            }

            public CreatedAt withGte(String gte) {
                this.gte = gte;
                return this;
            }

            public CreatedAt withLt(String lt) {
                this.lt = lt;
                return this;
            }

            public CreatedAt withLte(String lte) {
                this.lte = lte;
                return this;
            }

            public Map<String, Object> getQueryParams() {
                ImmutableMap.Builder params = ImmutableMap.builder();
                if (this.gt != null) {
                    params.put((Object)"created_at[gt]", (Object)this.gt);
                }
                if (this.gte != null) {
                    params.put((Object)"created_at[gte]", (Object)this.gte);
                }
                if (this.lt != null) {
                    params.put((Object)"created_at[lt]", (Object)this.lt);
                }
                if (this.lte != null) {
                    params.put((Object)"created_at[lte]", (Object)this.lte);
                }
                return params.build();
            }
        }
    }

    public static final class SubscriptionCreateRequest
    extends IdempotentPostRequest<Subscription> {
        private Integer amount;
        private Integer appFee;
        private Integer count;
        private String currency;
        private Integer dayOfMonth;
        private String endDate;
        private Integer interval;
        private IntervalUnit intervalUnit;
        private Links links;
        private Map<String, String> metadata;
        private Month month;
        private String name;
        private String paymentReference;
        private Boolean retryIfPossible;
        private String startDate;

        public SubscriptionCreateRequest withAmount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public SubscriptionCreateRequest withAppFee(Integer appFee) {
            this.appFee = appFee;
            return this;
        }

        public SubscriptionCreateRequest withCount(Integer count) {
            this.count = count;
            return this;
        }

        public SubscriptionCreateRequest withCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public SubscriptionCreateRequest withDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public SubscriptionCreateRequest withEndDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public SubscriptionCreateRequest withInterval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public SubscriptionCreateRequest withIntervalUnit(IntervalUnit intervalUnit) {
            this.intervalUnit = intervalUnit;
            return this;
        }

        public SubscriptionCreateRequest withLinks(Links links) {
            this.links = links;
            return this;
        }

        public SubscriptionCreateRequest withLinksMandate(String mandate) {
            if (this.links == null) {
                this.links = new Links();
            }
            this.links.withMandate(mandate);
            return this;
        }

        public SubscriptionCreateRequest withMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubscriptionCreateRequest withMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public SubscriptionCreateRequest withMonth(Month month) {
            this.month = month;
            return this;
        }

        public SubscriptionCreateRequest withName(String name) {
            this.name = name;
            return this;
        }

        public SubscriptionCreateRequest withPaymentReference(String paymentReference) {
            this.paymentReference = paymentReference;
            return this;
        }

        public SubscriptionCreateRequest withRetryIfPossible(Boolean retryIfPossible) {
            this.retryIfPossible = retryIfPossible;
            return this;
        }

        public SubscriptionCreateRequest withStartDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public SubscriptionCreateRequest withIdempotencyKey(String idempotencyKey) {
            super.setIdempotencyKey(idempotencyKey);
            return this;
        }

        @Override
        protected GetRequest<Subscription> handleConflict(HttpClient httpClient, String id) {
            SubscriptionGetRequest request = new SubscriptionGetRequest(httpClient, id);
            for (Map.Entry<String, String> header : this.getCustomHeaders().entrySet()) {
                request = request.withHeader(header.getKey(), header.getValue());
            }
            return request;
        }

        private SubscriptionCreateRequest(HttpClient httpClient) {
            super(httpClient);
        }

        public SubscriptionCreateRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected String getPathTemplate() {
            return "subscriptions";
        }

        @Override
        protected String getEnvelope() {
            return "subscriptions";
        }

        @Override
        protected Class<Subscription> getResponseClass() {
            return Subscription.class;
        }

        @Override
        protected boolean hasBody() {
            return true;
        }

        public static class Links {
            private String mandate;

            public Links withMandate(String mandate) {
                this.mandate = mandate;
                return this;
            }
        }

        public static enum Month {
            JANUARY,
            FEBRUARY,
            MARCH,
            APRIL,
            MAY,
            JUNE,
            JULY,
            AUGUST,
            SEPTEMBER,
            OCTOBER,
            NOVEMBER,
            DECEMBER,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }

        public static enum IntervalUnit {
            WEEKLY,
            MONTHLY,
            YEARLY,
            UNKNOWN;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }
}

