/*
 * Decompiled with CFR 0.152.
 */
package com.gocardless.services;

import com.gocardless.http.GetRequest;
import com.gocardless.http.HttpClient;
import com.gocardless.http.ListRequest;
import com.gocardless.http.ListResponse;
import com.gocardless.http.PathParam;
import com.gocardless.resources.TaxRate;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class TaxRateService {
    private final HttpClient httpClient;

    public TaxRateService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public TaxRateListRequest<ListResponse<TaxRate>> list() {
        return new TaxRateListRequest<ListResponse<TaxRate>>(this.httpClient, ListRequest.pagingExecutor());
    }

    public TaxRateListRequest<Iterable<TaxRate>> all() {
        return new TaxRateListRequest<Iterable<TaxRate>>(this.httpClient, ListRequest.iteratingExecutor());
    }

    public TaxRateGetRequest get(String identity) {
        return new TaxRateGetRequest(this.httpClient, identity);
    }

    public static final class TaxRateGetRequest
    extends GetRequest<TaxRate> {
        @PathParam
        private final String identity;

        private TaxRateGetRequest(HttpClient httpClient, String identity) {
            super(httpClient);
            this.identity = identity;
        }

        public TaxRateGetRequest withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, String> getPathParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"identity", (Object)this.identity);
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "tax_rates/:identity";
        }

        @Override
        protected String getEnvelope() {
            return "tax_rates";
        }

        @Override
        protected Class<TaxRate> getResponseClass() {
            return TaxRate.class;
        }
    }

    public static final class TaxRateListRequest<S>
    extends ListRequest<S, TaxRate> {
        private String jurisdiction;

        public TaxRateListRequest<S> withAfter(String after) {
            this.setAfter(after);
            return this;
        }

        public TaxRateListRequest<S> withBefore(String before) {
            this.setBefore(before);
            return this;
        }

        public TaxRateListRequest<S> withJurisdiction(String jurisdiction) {
            this.jurisdiction = jurisdiction;
            return this;
        }

        private TaxRateListRequest(HttpClient httpClient, ListRequest.ListRequestExecutor<S, TaxRate> executor) {
            super(httpClient, executor);
        }

        public TaxRateListRequest<S> withHeader(String headerName, String headerValue) {
            this.addHeader(headerName, headerValue);
            return this;
        }

        @Override
        protected Map<String, Object> getQueryParams() {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.putAll(super.getQueryParams());
            if (this.jurisdiction != null) {
                params.put((Object)"jurisdiction", (Object)this.jurisdiction);
            }
            return params.build();
        }

        @Override
        protected String getPathTemplate() {
            return "tax_rates";
        }

        @Override
        protected String getEnvelope() {
            return "tax_rates";
        }

        @Override
        protected TypeToken<List<TaxRate>> getTypeToken() {
            return new TypeToken<List<TaxRate>>(){};
        }
    }
}

