/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.util;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AddrUtil {
    public static Map<InetSocketAddress, InetSocketAddress> getAddressMap(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in list:  ``" + s + "''");
        }
        LinkedHashMap<InetSocketAddress, InetSocketAddress> result = new LinkedHashMap<InetSocketAddress, InetSocketAddress>();
        for (String hosts : s.split(" ")) {
            String[] nodes = hosts.split(",");
            if (nodes.length < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hosts + "'' in list:  " + s);
            }
            String mainHost = nodes[0];
            InetSocketAddress mainAddress = AddrUtil.getInetSocketAddress(s, mainHost);
            if (nodes.length >= 2) {
                InetSocketAddress standByAddress = AddrUtil.getInetSocketAddress(s, nodes[1]);
                result.put(mainAddress, standByAddress);
                continue;
            }
            result.put(mainAddress, null);
        }
        assert (!result.isEmpty()) : "No addrs found";
        return result;
    }

    private static InetSocketAddress getInetSocketAddress(String s, String mainHost) {
        int finalColon = mainHost.lastIndexOf(58);
        if (finalColon < 1) {
            throw new IllegalArgumentException("Invalid server ``" + mainHost + "'' in list:  " + s);
        }
        String hostPart = mainHost.substring(0, finalColon);
        String portNum = mainHost.substring(finalColon + 1);
        InetSocketAddress mainAddress = new InetSocketAddress(hostPart, Integer.parseInt(portNum));
        return mainAddress;
    }

    public static List<InetSocketAddress> getAddresses(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in list:  ``" + s + "''");
        }
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (String hoststuff : s.split(" ")) {
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hoststuff + "'' in list:  " + s);
            }
            String hostPart = hoststuff.substring(0, finalColon);
            String portNum = hoststuff.substring(finalColon + 1);
            addrs.add(new InetSocketAddress(hostPart, Integer.parseInt(portNum)));
        }
        assert (!addrs.isEmpty()) : "No addrs found";
        return addrs;
    }

    public static InetSocketAddress getOneAddress(String server) {
        if (server == null) {
            throw new NullPointerException("Null host");
        }
        if (server.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in:  ``" + server + "''");
        }
        int finalColon = server.lastIndexOf(58);
        if (finalColon < 1) {
            throw new IllegalArgumentException("Invalid server ``" + server + "''");
        }
        String hostPart = server.substring(0, finalColon);
        String portNum = server.substring(finalColon + 1);
        return new InetSocketAddress(hostPart, Integer.parseInt(portNum));
    }
}

