/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.util;

import org.apache.commons.lang3.ArrayUtils;

public class ArrayAssistance {
    public static void fill(byte[] target, int offset, byte[] source) {
        if (source != null) {
            for (int i = 0; i < source.length; ++i) {
                target[offset + i] = source[i];
            }
        }
    }

    public static byte[] trim(byte[] data, int offset, int length) {
        if (offset != 0 || length != data.length) {
            return ArrayUtils.subarray((byte[])data, (int)offset, (int)length);
        }
        return data;
    }

    public static byte[] join(byte[][] content) {
        byte[] result = content[0];
        for (int i = 1; i < content.length; ++i) {
            result = ArrayUtils.addAll((byte[])result, (byte[])content[i]);
        }
        return result;
    }

    public static byte[][] split(byte[] data, int mtu) {
        int times = data.length / mtu;
        if (data.length % mtu > 0) {
            ++times;
        }
        byte[][] result = new byte[times][];
        int startIndex = 0;
        int count = 0;
        do {
            result[count++] = ArrayUtils.subarray((byte[])data, (int)startIndex, (int)Math.min(data.length, startIndex + mtu));
        } while ((startIndex += mtu) < data.length);
        return result;
    }
}

