/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.util;

public class BigEndianUtils {
    public static int readInt(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | (b[3] & 0xFF) << 0;
    }

    public static short readShort(byte[] b) {
        return (short)((b[0] & 0xFF) << 8 | (b[1] & 0xFF) << 0);
    }

    public static int unassignedShort2Int(short input) {
        return input & 0xFFFF;
    }

    public static int unassignedbyte2Int(byte input) {
        return input & 0xFF;
    }

    public static int readIntFrom2ByteArray(byte[] b) {
        return BigEndianUtils.unassignedShort2Int(BigEndianUtils.readShort(b));
    }

    public static byte[] writeInt(int value) {
        byte[] data = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)};
        return data;
    }

    public static byte[] writeShort(short value) {
        byte[] data = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)};
        return data;
    }

    public static byte[] writeShortFromInt(int value) {
        return BigEndianUtils.writeShort((short)value);
    }
}

