/*
 * Decompiled with CFR 0.152.
 */
package com.godmonth.util.pressure;

import com.godmonth.util.pressure.Alcohol;
import com.godmonth.util.thread.EndlessTask;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedOperation;

public abstract class Liquor
implements Alcohol {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int threadNum;
    protected ThreadPoolExecutor executorService;
    protected Date startTime;

    protected void stopEs() {
        if (this.executorService != null) {
            this.getPressureTask().shutdown();
            this.getMonitorTask().shutdown();
            this.executorService.shutdownNow();
            while (true) {
                try {
                    this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.warn(null, (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    protected void createEs() {
        this.stopEs();
        this.executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();
    }

    @Override
    @ManagedOperation
    public void begin() {
        this.startTime = new Date();
        this.createEs();
        this.beforeBegin();
        this.executorService.submit(this.getMonitorTask());
        for (int i = 0; i < this.threadNum; ++i) {
            this.executorService.submit(this.getPressureTask());
        }
    }

    protected abstract EndlessTask getMonitorTask();

    protected abstract EndlessTask getPressureTask();

    protected void beforeBegin() {
    }

    @Override
    @ManagedOperation
    public void end() {
        this.stopEs();
        this.afterEnd();
    }

    protected void afterEnd() {
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }
}

